/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.valarian_conquest.init;

import net.mcreator.valarian_conquest.potion.CannonCooldownPotionMobEffect;
import net.mcreator.valarian_conquest.potion.MercFollowPotionMobEffect;
import net.mcreator.valarian_conquest.potion.MoveToPlayerPotionMobEffect;
import net.mcreator.valarian_conquest.potion.NoMovePotionMobEffect;
import net.mcreator.valarian_conquest.potion.SummonHorseMountPotionMobEffect;
import net.mcreator.valarian_conquest.procedures.SummonHorseMountProcedureProcedure;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class ValarianConquestModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"valarian_conquest");
    public static final DeferredHolder<MobEffect, MobEffect> NO_MOVE_POTION = REGISTRY.register("no_move_potion", () -> new NoMovePotionMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> CANNON_COOLDOWN_POTION = REGISTRY.register("cannon_cooldown_potion", () -> new CannonCooldownPotionMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> MOVE_TO_PLAYER_POTION = REGISTRY.register("move_to_player_potion", () -> new MoveToPlayerPotionMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> SUMMON_HORSE_MOUNT_POTION = REGISTRY.register("summon_horse_mount_potion", () -> new SummonHorseMountPotionMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> MERC_FOLLOW_POTION = REGISTRY.register("merc_follow_potion", () -> new MercFollowPotionMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            ValarianConquestModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            ValarianConquestModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(SUMMON_HORSE_MOUNT_POTION)) {
            SummonHorseMountProcedureProcedure.execute((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ(), entity);
        }
    }
}

