/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.valarian_conquest.network;

import net.mcreator.valarian_conquest.ValarianConquestMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class ValarianConquestModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"valarian_conquest");

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        ValarianConquestMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"valarian_conquest", (String)"saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            if (message.data != null) {
                buffer.writeNbt((Tag)message.data.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                }
            }
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    } else {
                        WorldVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "valarian_conquest_mapvars";
        public double constantplayerZ = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            MapVariables data = new MapVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.constantplayerZ = nbt.getDouble("constantplayerZ");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putDouble("constantplayerZ", this.constantplayerZ);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof Level && !world.isClientSide()) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(MapVariables::new, MapVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "valarian_conquest_worldvars";
        public double targetX1 = 0.0;
        public double targetY1 = 0.0;
        public double targetZ1 = 0.0;
        public double targetX2 = 0.0;
        public double targetY2 = 0.0;
        public double targetZ2 = 0.0;
        public double sendGroupX = 0.0;
        public double sendGroupY = 0.0;
        public double sendGroupZ = 0.0;
        public boolean joinedGroup1 = false;
        public double formationX = 0.0;
        public double formationZ = 0.0;
        public boolean raidplayerposition = false;
        public double constantplayerX = 0.0;
        public double constantplayerY = 0.0;
        public boolean gothere = false;
        public boolean regroup = false;
        public ItemStack lefthand = ItemStack.EMPTY;
        public ItemStack righthand = ItemStack.EMPTY;
        public double ambush = 0.0;
        public boolean spawnambush = false;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            WorldVariables data = new WorldVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.targetX1 = nbt.getDouble("targetX1");
            this.targetY1 = nbt.getDouble("targetY1");
            this.targetZ1 = nbt.getDouble("targetZ1");
            this.targetX2 = nbt.getDouble("targetX2");
            this.targetY2 = nbt.getDouble("targetY2");
            this.targetZ2 = nbt.getDouble("targetZ2");
            this.sendGroupX = nbt.getDouble("sendGroupX");
            this.sendGroupY = nbt.getDouble("sendGroupY");
            this.sendGroupZ = nbt.getDouble("sendGroupZ");
            this.joinedGroup1 = nbt.getBoolean("joinedGroup1");
            this.formationX = nbt.getDouble("formationX");
            this.formationZ = nbt.getDouble("formationZ");
            this.raidplayerposition = nbt.getBoolean("raidplayerposition");
            this.constantplayerX = nbt.getDouble("constantplayerX");
            this.constantplayerY = nbt.getDouble("constantplayerY");
            this.gothere = nbt.getBoolean("gothere");
            this.regroup = nbt.getBoolean("regroup");
            this.lefthand = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("lefthand"));
            this.righthand = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbt.getCompound("righthand"));
            this.ambush = nbt.getDouble("ambush");
            this.spawnambush = nbt.getBoolean("spawnambush");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putDouble("targetX1", this.targetX1);
            nbt.putDouble("targetY1", this.targetY1);
            nbt.putDouble("targetZ1", this.targetZ1);
            nbt.putDouble("targetX2", this.targetX2);
            nbt.putDouble("targetY2", this.targetY2);
            nbt.putDouble("targetZ2", this.targetZ2);
            nbt.putDouble("sendGroupX", this.sendGroupX);
            nbt.putDouble("sendGroupY", this.sendGroupY);
            nbt.putDouble("sendGroupZ", this.sendGroupZ);
            nbt.putBoolean("joinedGroup1", this.joinedGroup1);
            nbt.putDouble("formationX", this.formationX);
            nbt.putDouble("formationZ", this.formationZ);
            nbt.putBoolean("raidplayerposition", this.raidplayerposition);
            nbt.putDouble("constantplayerX", this.constantplayerX);
            nbt.putDouble("constantplayerY", this.constantplayerY);
            nbt.putBoolean("gothere", this.gothere);
            nbt.putBoolean("regroup", this.regroup);
            nbt.put("lefthand", this.lefthand.saveOptional(lookupProvider));
            nbt.put("righthand", this.righthand.saveOptional(lookupProvider));
            nbt.putDouble("ambush", this.ambush);
            nbt.putBoolean("spawnambush", this.spawnambush);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)new SavedDataSyncMessage(1, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(new SavedData.Factory(WorldVariables::new, WorldVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (mapdata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }
}

