/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.raided.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.mrbysco.raided.client.ClientHandler;
import com.mrbysco.raided.entity.projectiles.LightningProjectile;
import net.minecraft.client.model.ShulkerBulletModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class LightningProjectileRenderer
extends EntityRenderer<LightningProjectile> {
    private static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"raided", (String)"textures/entity/projectile/lightning.png");
    private static final RenderType RENDER_TYPE = RenderType.entityTranslucent((ResourceLocation)TEXTURE_LOCATION);
    private final ShulkerBulletModel<LightningProjectile> model;

    public LightningProjectileRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new ShulkerBulletModel(context.bakeLayer(ClientHandler.LIGHTNING_PROJECTILE));
    }

    protected int getBlockLightLevel(LightningProjectile projectile, BlockPos pos) {
        return 15;
    }

    public void render(LightningProjectile projectile, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        float f = Mth.rotLerp((float)projectile.yRotO, (float)projectile.getYRot(), (float)partialTicks);
        float f1 = Mth.lerp((float)partialTicks, (float)projectile.xRotO, (float)projectile.getXRot());
        float f2 = (float)projectile.tickCount + partialTicks;
        poseStack.translate(0.0, (double)0.15f, 0.0);
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.sin((float)(f2 * 0.1f)) * 180.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees(Mth.cos((float)(f2 * 0.1f)) * 180.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.sin((float)(f2 * 0.15f)) * 360.0f));
        poseStack.scale(-0.5f, -0.5f, 0.5f);
        this.model.setupAnim((Entity)projectile, 0.0f, 0.0f, 0.0f, f, f1);
        VertexConsumer vertexconsumer = bufferSource.getBuffer(this.model.renderType(TEXTURE_LOCATION));
        this.model.renderToBuffer(poseStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.scale(1.5f, 1.5f, 1.5f);
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RENDER_TYPE);
        this.model.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, 0x26FFFFFF);
        poseStack.popPose();
        super.render((Entity)projectile, entityYaw, partialTicks, poseStack, bufferSource, packedLight);
    }

    public ResourceLocation getTextureLocation(LightningProjectile projectile) {
        return TEXTURE_LOCATION;
    }
}

