/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.raided.config;

import com.mrbysco.raided.Raided;
import java.util.List;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class RaidedConfig {
    protected static final Integer[] inquisitorSpawns = new Integer[]{0, 0, 0, 3, 0, 0, 0, 0};
    protected static final Integer[] incineratorSpawns = new Integer[]{0, 0, 0, 0, 1, 0, 0, 1};
    protected static final Integer[] savagerSpawns = new Integer[]{0, 0, 0, 2, 0, 0, 1, 0};
    protected static final Integer[] necromancerSpawns = new Integer[]{0, 0, 1, 0, 0, 1, 0, 0};
    protected static final Integer[] electromancerSpawns = new Integer[]{0, 1, 0, 2, 0, 1, 0, 0};
    public static final ModConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        Raided.LOGGER.debug("Loaded Raided's config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        Raided.LOGGER.debug("Raided's config just got changed on the file system!");
        if (!configEvent.getConfig().getModId().equals("raided") || RaidedConfig.validateValue(RaidedConfig.COMMON.inquisitorSpawnsPerWave, inquisitorSpawns) || RaidedConfig.validateValue(RaidedConfig.COMMON.incineratorSpawnsPerWave, incineratorSpawns) || RaidedConfig.validateValue(RaidedConfig.COMMON.savagerSpawnsPerWave, savagerSpawns) || RaidedConfig.validateValue(RaidedConfig.COMMON.necromancerSpawnsPerWave, necromancerSpawns) || RaidedConfig.validateValue(RaidedConfig.COMMON.electromancerSpawnsPerWave, electromancerSpawns)) {
            // empty if block
        }
    }

    public static boolean validateValue(ModConfigSpec.ConfigValue<List<? extends Integer>> configValue, Integer[] defaults) {
        if (((List)configValue.get()).size() != defaults.length) {
            Raided.LOGGER.error("'{}' is not the correct length, resetting to default. There must always be {} values in the list while it had {}", configValue.getPath().get(0), (Object)defaults.length, (Object)((List)configValue.get()).size());
            configValue.set(List.of(incineratorSpawns));
            return true;
        }
        return false;
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Common::new);
        commonSpec = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ModConfigSpec.ConfigValue<List<? extends Integer>> inquisitorSpawnsPerWave;
        public final ModConfigSpec.ConfigValue<List<? extends Integer>> incineratorSpawnsPerWave;
        public final ModConfigSpec.ConfigValue<List<? extends Integer>> savagerSpawnsPerWave;
        public final ModConfigSpec.ConfigValue<List<? extends Integer>> necromancerSpawnsPerWave;
        public final ModConfigSpec.ConfigValue<List<? extends Integer>> electromancerSpawnsPerWave;

        Common(ModConfigSpec.Builder builder) {
            builder.comment("General settings").push("General");
            this.inquisitorSpawnsPerWave = builder.comment("The spawns per wave for the Inquisitor before bonus spawns are applied (Must always have 8 values!)").defineList(List.of("inquisitorSpawnsPerWave"), () -> List.of(inquisitorSpawns), o -> {
                Integer amount;
                return o instanceof Integer && (amount = (Integer)o) >= 0;
            });
            this.incineratorSpawnsPerWave = builder.comment("The spawns per wave for the Incinerator before bonus spawns are applied (Must always have 8 values!)").defineList(List.of("incineratorSpawnsPerWave"), () -> List.of(incineratorSpawns), o -> {
                Integer amount;
                return o instanceof Integer && (amount = (Integer)o) >= 0;
            });
            this.savagerSpawnsPerWave = builder.comment("The spawns per wave for the Savager before bonus spawns are applied (Must always have 8 values!)").defineList(List.of("savagerSpawnsPerWave"), () -> List.of(savagerSpawns), o -> {
                Integer amount;
                return o instanceof Integer && (amount = (Integer)o) >= 0;
            });
            this.necromancerSpawnsPerWave = builder.comment("The spawns per wave for the Necromancer before bonus spawns are applied (Must always have 8 values!)").defineList(List.of("necromancerSpawnsPerWave"), () -> List.of(necromancerSpawns), o -> {
                Integer amount;
                return o instanceof Integer && (amount = (Integer)o) >= 0;
            });
            this.electromancerSpawnsPerWave = builder.comment("The spawns per wave for the Electromancer before bonus spawns are applied (Must always have 8 values!)").defineList(List.of("electromancerSpawnsPerWave"), () -> List.of(electromancerSpawns), o -> {
                Integer amount;
                return o instanceof Integer && (amount = (Integer)o) >= 0;
            });
            builder.pop();
        }
    }
}

