/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.raided.datagen;

import com.mrbysco.raided.registry.RaidRegHelper;
import com.mrbysco.raided.registry.RaidedRegistry;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.WritableRegistry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.common.data.SoundDefinition;
import net.neoforged.neoforge.common.data.SoundDefinitionsProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class RaidedDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        PackOutput packOutput = generator.getPackOutput();
        if (event.includeServer()) {
            generator.addProvider(event.includeServer(), (DataProvider)new Loots(packOutput, event.getLookupProvider()));
        }
        if (event.includeClient()) {
            generator.addProvider(event.includeClient(), (DataProvider)new Language(packOutput));
            generator.addProvider(event.includeClient(), (DataProvider)new ItemModels(packOutput, helper));
            generator.addProvider(event.includeClient(), (DataProvider)new SoundProvider(packOutput, helper));
        }
    }

    private static class Loots
    extends LootTableProvider {
        public Loots(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(RaidedLootTables::new, LootContextParamSets.ENTITY)), lookupProvider);
        }

        protected void validate(WritableRegistry<LootTable> writableregistry, ValidationContext validationcontext, ProblemReporter.Collector problemreporter$collector) {
            super.validate(writableregistry, validationcontext, problemreporter$collector);
        }

        public static class RaidedLootTables
        extends EntityLootSubProvider {
            protected RaidedLootTables(HolderLookup.Provider provider) {
                super(FeatureFlags.REGISTRY.allFlags(), provider);
            }

            public void generate() {
                this.add(RaidedRegistry.INQUISITOR.getEntityType(), LootTable.lootTable());
                this.add(RaidedRegistry.INCINERATOR.getEntityType(), LootTable.lootTable());
                this.add(RaidedRegistry.SAVAGER.getEntityType(), LootTable.lootTable());
                this.add(RaidedRegistry.NECROMANCER.getEntityType(), LootTable.lootTable());
                this.add(RaidedRegistry.ELECTROMANCER.getEntityType(), LootTable.lootTable());
            }

            protected Stream<EntityType<?>> getKnownEntityTypes() {
                return RaidedRegistry.ENTITY_TYPES.getEntries().stream().map(Supplier::get);
            }
        }
    }

    private static class Language
    extends LanguageProvider {
        public Language(PackOutput packOutput) {
            super(packOutput, "raided", "en_us");
        }

        protected void addTranslations() {
            this.addHelper(RaidedRegistry.INQUISITOR, "Inquisitor");
            this.addHelper(RaidedRegistry.INCINERATOR, "Incinerator");
            this.addHelper(RaidedRegistry.SAVAGER, "Savager");
            this.addHelper(RaidedRegistry.NECROMANCER, "Necromancer");
            this.addHelper(RaidedRegistry.ELECTROMANCER, "Electromancer");
            this.addSubtitle((SoundEvent)RaidedRegistry.ELECROMANCER_PREPARE_CONVERSION.get(), "Electromancer prepares conversion");
        }

        private void addHelper(RaidRegHelper helper, String name) {
            this.add(helper.getEntityType(), name);
            this.addItem((Supplier)helper.getSpawnEgg(), name + " Spawn Egg");
            this.addSubtitle(helper.getAmbient(), name + " mutters");
            this.addSubtitle(helper.getDeath(), name + " dies");
            this.addSubtitle(helper.getHurt(), name + " hurts");
            this.addSubtitle(helper.getCelebrate(), name + " cheers");
            if (helper.getCasting() != null) {
                this.addSubtitle(helper.getCasting(), name + " casts spell");
            }
        }

        public void addSubtitle(SoundEvent sound, String name) {
            String path = "raided.subtitle." + sound.getLocation().getPath();
            this.add(path, name);
        }
    }

    private static class ItemModels
    extends ItemModelProvider {
        public ItemModels(PackOutput packOutput, ExistingFileHelper helper) {
            super(packOutput, "raided", helper);
        }

        protected void registerModels() {
            for (DeferredHolder item : RaidedRegistry.ITEMS.getEntries()) {
                if (!(item.get() instanceof SpawnEggItem)) continue;
                this.withExistingParent(item.getId().getPath(), ResourceLocation.withDefaultNamespace((String)"item/template_spawn_egg"));
            }
        }
    }

    private static class SoundProvider
    extends SoundDefinitionsProvider {
        public SoundProvider(PackOutput packOutput, ExistingFileHelper helper) {
            super(packOutput, "raided", helper);
        }

        public void registerSounds() {
            this.addHelper(RaidedRegistry.INQUISITOR);
            this.addHelper(RaidedRegistry.INCINERATOR);
            this.addHelper(RaidedRegistry.SAVAGER);
            this.addHelper(RaidedRegistry.NECROMANCER);
            this.addHelper(RaidedRegistry.ELECTROMANCER);
            this.add((SoundEvent)RaidedRegistry.ELECROMANCER_PREPARE_CONVERSION.get(), SoundProvider.definition().with(SoundProvider.sound((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"mob/evocation_illager/prepare_wololo"))).subtitle(this.modSubtitle(RaidedRegistry.ELECROMANCER_PREPARE_CONVERSION.getId())));
        }

        private void addHelper(RaidRegHelper helper) {
            this.add(helper.getAmbient(), SoundProvider.definition().with(new SoundDefinition.Sound[]{SoundProvider.sound((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"mob/evocation_illager/idle1")), SoundProvider.sound((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"mob/evocation_illager/idle2")), SoundProvider.sound((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"mob/evocation_illager/idle3")), SoundProvider.sound((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"mob/evocation_illager/idle4"))}).subtitle(this.modSubtitle(helper.getAmbient().getLocation())));
            this.add(helper.getDeath(), SoundProvider.definition().with(new SoundDefinition.Sound[]{SoundProvider.sound((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"mob/evocation_illager/death1")), SoundProvider.sound((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"mob/evocation_illager/death2"))}).subtitle(this.modSubtitle(helper.getDeath().getLocation())));
            this.add(helper.getHurt(), SoundProvider.definition().with(new SoundDefinition.Sound[]{SoundProvider.sound((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"mob/evocation_illager/hurt1")), SoundProvider.sound((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"mob/evocation_illager/hurt2"))}).subtitle(this.modSubtitle(helper.getDeath().getLocation())));
            this.add(helper.getCelebrate(), SoundProvider.definition().with(new SoundDefinition.Sound[]{SoundProvider.sound((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"mob/evocation_illager/celebrate")), SoundProvider.sound((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"mob/evocation_illager/idle1")), SoundProvider.sound((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"mob/evocation_illager/idle2"))}).subtitle(this.modSubtitle(helper.getCelebrate().getLocation())));
            if (helper.getCasting() != null) {
                this.add(helper.getCasting(), SoundProvider.definition().with(new SoundDefinition.Sound[]{SoundProvider.sound((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"mob/evocation_illager/cast1")), SoundProvider.sound((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"mob/evocation_illager/cast2"))}).subtitle(this.modSubtitle(helper.getCasting().getLocation())));
            }
        }

        public String modSubtitle(ResourceLocation id) {
            return "raided.subtitle." + id.getPath();
        }
    }
}

