/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.raided.entity;

import com.mrbysco.raided.registry.RaidedRegistry;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class Inquisitor
extends AbstractIllager {
    private static final EntityDataAccessor<Integer> INQUISITOR_TYPE = SynchedEntityData.defineId(Inquisitor.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public Inquisitor(EntityType<? extends AbstractIllager> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.goalSelector.addGoal(3, (Goal)new InquisitorMeleeAttackGoal(this));
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.75));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 15.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(INQUISITOR_TYPE, (Object)0);
    }

    public int getInquisitorType() {
        return (Integer)this.entityData.get(INQUISITOR_TYPE);
    }

    public void setInquisitorType(int index) {
        this.entityData.set(INQUISITOR_TYPE, (Object)index);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.MAX_HEALTH, 20.0).add(Attributes.ATTACK_DAMAGE, 2.0);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("InquisitorType", this.getInquisitorType());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setInquisitorType(tag.getInt("InquisitorType"));
    }

    public boolean isAlliedTo(Entity entity) {
        if (super.isAlliedTo(entity)) {
            return true;
        }
        if (entity instanceof LivingEntity && ((LivingEntity)entity).getType().is(EntityTypeTags.ILLAGER)) {
            return this.getTeam() == null && entity.getTeam() == null;
        }
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.hasShield()) {
            Entity entity = source.getDirectEntity();
            return !(entity instanceof Projectile) ? super.hurt(source, amount) : false;
        }
        return super.hurt(source, amount);
    }

    private boolean hasShield() {
        ItemStack itemstack = this.getItemBySlot(EquipmentSlot.OFFHAND);
        return itemstack.getItem() instanceof ShieldItem;
    }

    public AbstractIllager.IllagerArmPose getArmPose() {
        if (this.isAggressive()) {
            return AbstractIllager.IllagerArmPose.ATTACKING;
        }
        return this.isCelebrating() ? AbstractIllager.IllagerArmPose.CELEBRATING : AbstractIllager.IllagerArmPose.CROSSED;
    }

    public void applyRaidBuffs(ServerLevel p_348605_, int p_37844_, boolean p_37845_) {
        if (this.random.nextFloat() < 0.25f) {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.SHIELD));
        }
    }

    public boolean canBeLeader() {
        return false;
    }

    protected SoundEvent getAmbientSound() {
        return RaidedRegistry.INQUISITOR.getAmbient();
    }

    protected SoundEvent getDeathSound() {
        return RaidedRegistry.INQUISITOR.getDeath();
    }

    protected SoundEvent getHurtSound(DamageSource p_33306_) {
        return RaidedRegistry.INQUISITOR.getHurt();
    }

    public SoundEvent getCelebrateSound() {
        return RaidedRegistry.INQUISITOR.getCelebrate();
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        groupData = super.finalizeSpawn(levelAccessor, difficultyInstance, spawnType, groupData);
        ((GroundPathNavigation)this.getNavigation()).setCanOpenDoors(true);
        this.setInquisitorType(this.random.nextInt(3) + 1);
        this.populateDefaultEquipmentSlots(this.random, difficultyInstance);
        this.populateDefaultEquipmentEnchantments(levelAccessor, this.random, difficultyInstance);
        this.setCanPickUpLoot(this.random.nextFloat() < 0.55f * difficultyInstance.getSpecialMultiplier());
        return groupData;
    }

    static class InquisitorMeleeAttackGoal
    extends MeleeAttackGoal {
        public InquisitorMeleeAttackGoal(Inquisitor inquisitor) {
            super((PathfinderMob)inquisitor, 1.0, false);
        }
    }
}

