/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.raided.entity;

import com.mrbysco.raided.entity.goal.RaiderHurtByTargetGoal;
import com.mrbysco.raided.registry.RaidedRegistry;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class Savager
extends Raider {
    private static final Predicate<LivingEntity> IS_TAMED = livingEntity -> {
        TamableAnimal tamableAnimal;
        return livingEntity instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)livingEntity).isAlive() && !(tamableAnimal.getOwner() instanceof Raider);
    };

    public Savager(EntityType<? extends Raider> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new RaiderHurtByTargetGoal(this));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, TamableAnimal.class, true, IS_TAMED));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 16.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.FOLLOW_RANGE, 24.0);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
    }

    public void applyRaidBuffs(ServerLevel p_348605_, int p_37844_, boolean p_37845_) {
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        groupData = super.finalizeSpawn(levelAccessor, difficultyInstance, spawnType, groupData);
        this.setCanPickUpLoot(false);
        return groupData;
    }

    public boolean canBeLeader() {
        return false;
    }

    protected SoundEvent getAmbientSound() {
        return RaidedRegistry.SAVAGER.getAmbient();
    }

    protected SoundEvent getDeathSound() {
        return RaidedRegistry.SAVAGER.getDeath();
    }

    protected SoundEvent getHurtSound(DamageSource p_33306_) {
        return RaidedRegistry.SAVAGER.getHurt();
    }

    public SoundEvent getCelebrateSound() {
        return RaidedRegistry.SAVAGER.getCelebrate();
    }
}

