/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.raided.registry;

import com.mrbysco.raided.entity.Electromancer;
import com.mrbysco.raided.entity.Incinerator;
import com.mrbysco.raided.entity.Inquisitor;
import com.mrbysco.raided.entity.Necromancer;
import com.mrbysco.raided.entity.Savager;
import com.mrbysco.raided.entity.projectiles.IncineratorFireball;
import com.mrbysco.raided.entity.projectiles.LightningProjectile;
import com.mrbysco.raided.registry.RaidRegHelper;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class RaidedRegistry {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"raided");
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"raided");
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((ResourceKey)Registries.SOUND_EVENT, (String)"raided");
    public static final RaidRegHelper<Inquisitor> INQUISITOR = new RaidRegHelper("inquisitor", EntityType.Builder.of(Inquisitor::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.95f).clientTrackingRange(8), 0x959B9B, 4143927);
    public static final RaidRegHelper<Incinerator> INCINERATOR = new RaidRegHelper("incinerator", EntityType.Builder.of(Incinerator::new, (MobCategory)MobCategory.MONSTER).sized(1.4f, 2.2f).fireImmune().clientTrackingRange(8), 0x959B9B, 4143927);
    public static final Supplier<EntityType<IncineratorFireball>> INCINERATOR_FIREBALL = ENTITY_TYPES.register("incinerator_fireball", () -> RaidedRegistry.register("incinerator_fireball", EntityType.Builder.of(IncineratorFireball::new, (MobCategory)MobCategory.MISC).sized(0.3125f, 0.3125f).clientTrackingRange(4).updateInterval(10)));
    public static final RaidRegHelper<Savager> SAVAGER = new RaidRegHelper("savager", EntityType.Builder.of(Savager::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 0.85f).clientTrackingRange(10), 0x959B9B, 4143927);
    public static final RaidRegHelper<Necromancer> NECROMANCER = new RaidRegHelper("necromancer", EntityType.Builder.of(Necromancer::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.95f).clientTrackingRange(8), 0x959B9B, 4143927);
    public static final RaidRegHelper<Electromancer> ELECTROMANCER = new RaidRegHelper("electromancer", EntityType.Builder.of(Electromancer::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.95f).clientTrackingRange(8), 0x959B9B, 4143927, true);
    public static final Supplier<EntityType<LightningProjectile>> LIGHTNING_PROJECTILE = ENTITY_TYPES.register("lightning", () -> RaidedRegistry.register("lightning", EntityType.Builder.of(LightningProjectile::new, (MobCategory)MobCategory.MISC).sized(0.3125f, 0.3125f).clientTrackingRange(4).updateInterval(10)));
    public static final DeferredHolder<SoundEvent, SoundEvent> ELECROMANCER_PREPARE_CONVERSION = SOUND_EVENTS.register("entity.electromancer.prepare_conversion", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"raided", (String)"entity.electromancer.prepare_conversion")));

    private static <T extends Entity> EntityType<T> register(String id, EntityType.Builder<T> builder) {
        return builder.build(id);
    }
}

