/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.common.light;

import ca.spottedleaf.starlight.common.blockstate.ExtendedAbstractBlockState;
import ca.spottedleaf.starlight.common.chunk.ExtendedChunk;
import ca.spottedleaf.starlight.common.light.SWMRNibbleArray;
import ca.spottedleaf.starlight.common.light.StarLightEngine;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class BlockStarLightEngine
extends StarLightEngine {
    protected final BlockPos.MutableBlockPos recalcCenterPos = new BlockPos.MutableBlockPos();
    protected final BlockPos.MutableBlockPos recalcNeighbourPos = new BlockPos.MutableBlockPos();

    public BlockStarLightEngine(Level world) {
        super(false, world);
    }

    @Override
    protected boolean[] getEmptinessMap(ChunkAccess chunk) {
        return ((ExtendedChunk)chunk).getBlockEmptinessMap();
    }

    @Override
    protected void setEmptinessMap(ChunkAccess chunk, boolean[] to) {
        ((ExtendedChunk)chunk).setBlockEmptinessMap(to);
    }

    @Override
    protected SWMRNibbleArray[] getNibblesOnChunk(ChunkAccess chunk) {
        return ((ExtendedChunk)chunk).getBlockNibbles();
    }

    @Override
    protected void setNibbles(ChunkAccess chunk, SWMRNibbleArray[] to) {
        ((ExtendedChunk)chunk).setBlockNibbles(to);
    }

    @Override
    protected boolean canUseChunk(ChunkAccess chunk) {
        return chunk.getPersistedStatus().isOrAfter(ChunkStatus.LIGHT) && (this.isClientSide || chunk.isLightCorrect());
    }

    @Override
    protected void setNibbleNull(int chunkX, int chunkY, int chunkZ) {
        SWMRNibbleArray nibble = this.getNibbleFromCache(chunkX, chunkY, chunkZ);
        if (nibble != null) {
            nibble.setHidden();
        }
    }

    @Override
    protected void initNibble(int chunkX, int chunkY, int chunkZ, boolean extrude, boolean initRemovedNibbles) {
        if (chunkY < this.minLightSection || chunkY > this.maxLightSection || this.getChunkInCache(chunkX, chunkZ) == null) {
            return;
        }
        SWMRNibbleArray nibble = this.getNibbleFromCache(chunkX, chunkY, chunkZ);
        if (nibble == null) {
            if (!initRemovedNibbles) {
                throw new IllegalStateException();
            }
            this.setNibbleInCache(chunkX, chunkY, chunkZ, new SWMRNibbleArray());
        } else {
            nibble.setNonNull();
        }
    }

    @Override
    protected final void checkBlock(LightChunkGetter lightAccess, int worldX, int worldY, int worldZ) {
        int encodeOffset = this.coordinateOffset;
        int emittedMask = this.emittedLightMask;
        int currentLevel = this.getLightLevel(worldX, worldY, worldZ);
        BlockState blockState = this.getBlockState(worldX, worldY, worldZ);
        this.checkBlockPos.set(worldX, worldY, worldZ);
        int emittedLevel = blockState.getLightEmission(lightAccess.getLevel(), (BlockPos)this.checkBlockPos) & emittedMask;
        this.setLightLevel(worldX, worldY, worldZ, emittedLevel);
        if (emittedLevel != 0) {
            this.appendToIncreaseQueue((long)(worldX + (worldZ << 6) + (worldY << 12) + encodeOffset) & 0xFFFFFFFL | ((long)emittedLevel & 0xFL) << 28 | 0x3F00000000L | (((ExtendedAbstractBlockState)blockState).isConditionallyFullOpaque() ? Long.MIN_VALUE : 0L));
        }
        this.appendToDecreaseQueue((long)(worldX + (worldZ << 6) + (worldY << 12) + encodeOffset) & 0xFFFFFFFL | ((long)currentLevel & 0xFL) << 28 | 0x3F00000000L);
    }

    @Override
    protected int calculateLightValue(LightChunkGetter lightAccess, int worldX, int worldY, int worldZ, int expect) {
        Object conditionallyOpaqueState;
        BlockState centerState = this.getBlockState(worldX, worldY, worldZ);
        this.recalcCenterPos.set(worldX, worldY, worldZ);
        int level = centerState.getLightEmission(lightAccess.getLevel(), (BlockPos)this.recalcCenterPos) & 0xF;
        if (level >= 14 || level > expect) {
            return level;
        }
        int sectionOffset = this.chunkSectionIndexOffset;
        int opacity = ((ExtendedAbstractBlockState)centerState).getOpacityIfCached();
        if (opacity == -1) {
            opacity = centerState.getLightBlock(lightAccess.getLevel(), (BlockPos)this.recalcCenterPos);
            conditionallyOpaqueState = ((ExtendedAbstractBlockState)centerState).isConditionallyFullOpaque() ? centerState : null;
        } else {
            if (opacity >= 15) {
                return level;
            }
            conditionallyOpaqueState = null;
        }
        opacity = Math.max(1, opacity);
        for (StarLightEngine.AxisDirection direction : AXIS_DIRECTIONS) {
            int calculated;
            int offX = worldX + direction.x;
            int offZ = worldZ + direction.z;
            int offY = worldY + direction.y;
            int sectionIndex = (offX >> 4) + 5 * (offZ >> 4) + 25 * (offY >> 4) + sectionOffset;
            int neighbourLevel = this.getLightLevel(sectionIndex, offX & 0xF | (offZ & 0xF) << 4 | (offY & 0xF) << 8);
            if (neighbourLevel - 1 <= level) continue;
            BlockState neighbourState = this.getBlockState(offX, offY, offZ);
            if (((ExtendedAbstractBlockState)neighbourState).isConditionallyFullOpaque()) {
                VoxelShape thisFace;
                this.recalcNeighbourPos.set(offX, offY, offZ);
                VoxelShape neighbourFace = neighbourState.getFaceOcclusionShape(lightAccess.getLevel(), (BlockPos)this.recalcNeighbourPos, direction.opposite.nms);
                VoxelShape voxelShape = thisFace = conditionallyOpaqueState == null ? Shapes.empty() : conditionallyOpaqueState.getFaceOcclusionShape(lightAccess.getLevel(), (BlockPos)this.recalcCenterPos, direction.nms);
                if (Shapes.faceShapeOccludes((VoxelShape)thisFace, (VoxelShape)neighbourFace)) continue;
            }
            if ((level = Math.max(calculated = neighbourLevel - opacity, level)) <= expect) continue;
            return level;
        }
        return level;
    }

    @Override
    protected void propagateBlockChanges(LightChunkGetter lightAccess, ChunkAccess atChunk, Set<BlockPos> positions) {
        for (BlockPos pos : positions) {
            this.checkBlock(lightAccess, pos.getX(), pos.getY(), pos.getZ());
        }
        this.performLightDecrease(lightAccess);
    }

    protected List<BlockPos> getSources(LightChunkGetter lightAccess, ChunkAccess chunk) {
        ArrayList<BlockPos> sources = new ArrayList<BlockPos>();
        int offX = chunk.getPos().x << 4;
        int offZ = chunk.getPos().z << 4;
        LevelChunkSection[] sections = chunk.getSections();
        for (int sectionY = this.minSection; sectionY <= this.maxSection; ++sectionY) {
            LevelChunkSection section = sections[sectionY - this.minSection];
            if (section == null || section.hasOnlyAir() || !section.maybeHas(blockState -> ((ExtendedAbstractBlockState)blockState).scalablelux$actuallyDynamicLightEmission() || blockState.getLightEmission() != 0)) continue;
            PalettedContainer states = section.states;
            int offY = sectionY << 4;
            for (int index = 0; index < 4096; ++index) {
                BlockState state = (BlockState)states.get(index);
                this.mutablePos4.set(offX | index & 0xF, offY | index >>> 8, offZ | index >>> 4 & 0xF);
                if (state.getLightEmission(lightAccess.getLevel(), (BlockPos)this.mutablePos1) <= 0) continue;
                sources.add(new BlockPos(offX | index & 0xF, offY | index >>> 8, offZ | index >>> 4 & 0xF));
            }
        }
        return sources;
    }

    @Override
    public void lightChunk(LightChunkGetter lightAccess, ChunkAccess chunk, boolean needsEdgeChecks) {
        int emittedMask = this.emittedLightMask;
        List<BlockPos> positions = this.getSources(lightAccess, chunk);
        int len = positions.size();
        for (int i = 0; i < len; ++i) {
            BlockPos pos = positions.get(i);
            BlockState blockState = this.getBlockState(pos.getX(), pos.getY(), pos.getZ());
            int emittedLight = blockState.getLightEmission(lightAccess.getLevel(), pos) & emittedMask;
            if (emittedLight <= this.getLightLevel(pos.getX(), pos.getY(), pos.getZ())) continue;
            this.appendToIncreaseQueue((long)(pos.getX() + (pos.getZ() << 6) + (pos.getY() << 12) + this.coordinateOffset) & 0xFFFFFFFL | ((long)emittedLight & 0xFL) << 28 | 0x3F00000000L | (((ExtendedAbstractBlockState)blockState).isConditionallyFullOpaque() ? Long.MIN_VALUE : 0L));
            this.setLightLevel(pos.getX(), pos.getY(), pos.getZ(), emittedLight);
        }
        if (needsEdgeChecks) {
            this.performLightIncrease(lightAccess);
            this.checkChunkEdges(lightAccess, chunk, this.minLightSection, this.maxLightSection);
        } else {
            this.propagateNeighbourLevels(lightAccess, chunk, this.minLightSection, this.maxLightSection);
            this.performLightIncrease(lightAccess);
        }
    }
}

