/*
 * Decompiled with CFR 0.152.
 */
package net.Pandarix.block;

import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.Pandarix.BACommon;
import net.Pandarix.block.custom.ArchelogyTable;
import net.Pandarix.block.custom.ChickenFossilBlock;
import net.Pandarix.block.custom.ChickenFossilBodyBlock;
import net.Pandarix.block.custom.ChickenFossilHeadBlock;
import net.Pandarix.block.custom.CreeperFossilBlock;
import net.Pandarix.block.custom.CreeperFossilBodyBlock;
import net.Pandarix.block.custom.CreeperFossilHeadBlock;
import net.Pandarix.block.custom.EvokerTrapBlock;
import net.Pandarix.block.custom.FossilBaseBlock;
import net.Pandarix.block.custom.FossilBaseBodyBlock;
import net.Pandarix.block.custom.FossilBaseHeadBlock;
import net.Pandarix.block.custom.FossilBaseWithEntityBlock;
import net.Pandarix.block.custom.GrowthTotemBlock;
import net.Pandarix.block.custom.GuardianFossilBlock;
import net.Pandarix.block.custom.GuardianFossilBodyBlock;
import net.Pandarix.block.custom.GuardianFossilHeadBlock;
import net.Pandarix.block.custom.LootVaseBlock;
import net.Pandarix.block.custom.OcelotFossilBlock;
import net.Pandarix.block.custom.OcelotFossilBodyBlock;
import net.Pandarix.block.custom.OcelotFossilHeadBlock;
import net.Pandarix.block.custom.RadianceTotemBlock;
import net.Pandarix.block.custom.SheepFossilBlock;
import net.Pandarix.block.custom.SheepFossilBodyBlock;
import net.Pandarix.block.custom.SheepFossilHeadBlock;
import net.Pandarix.block.custom.SusBlock;
import net.Pandarix.block.custom.VaseBlock;
import net.Pandarix.block.custom.VillagerFossilBlock;
import net.Pandarix.block.custom.VillagerFossilBodyBlock;
import net.Pandarix.block.custom.VillagerFossilHeadBlock;
import net.Pandarix.block.custom.WolfFossilBlock;
import net.Pandarix.block.custom.WolfFossilBodyBlock;
import net.Pandarix.block.custom.WolfFossilHeadBlock;
import net.Pandarix.item.ModItems;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.InfestedBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class ModBlocks {
    public static final Registrar<Block> BLOCKS = BACommon.REGISTRIES.get().get(Registries.BLOCK);
    public static final RegistrySupplier<Block> SUSPICIOUS_RED_SAND = ModBlocks.registerBlock("suspicious_red_sand", () -> new SusBlock(Blocks.RED_SAND, BlockBehaviour.Properties.of().mapColor(MapColor.SAND).instrument(NoteBlockInstrument.SNARE).strength(0.25f).sound(SoundType.SUSPICIOUS_SAND).pushReaction(PushReaction.DESTROY), SoundEvents.BRUSH_SAND, SoundEvents.BRUSH_SAND_COMPLETED));
    public static final RegistrySupplier<Block> SUSPICIOUS_DIRT = ModBlocks.registerBlock("suspicious_dirt", () -> new SusBlock(Blocks.DIRT, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.SNARE).strength(0.25f).sound(SoundType.SUSPICIOUS_GRAVEL).pushReaction(PushReaction.DESTROY), SoundEvents.BRUSH_GRAVEL, SoundEvents.BRUSH_GRAVEL_COMPLETED));
    public static final RegistrySupplier<Block> FOSSILIFEROUS_DIRT = ModBlocks.registerBlock("fossiliferous_dirt", () -> new SusBlock(Blocks.DIRT, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.SNARE).strength(0.25f).sound(SoundType.SUSPICIOUS_GRAVEL).pushReaction(PushReaction.DESTROY), SoundEvents.BRUSH_GRAVEL, SoundEvents.BRUSH_GRAVEL_COMPLETED));
    public static final RegistrySupplier<Block> CHISELED_BONE_BLOCK = ModBlocks.registerBlock("chiseled_bone_block", () -> new RotatedPillarBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(0.3f).instrument(NoteBlockInstrument.XYLOPHONE).sound(SoundType.BONE_BLOCK)));
    public static final RegistrySupplier<Block> VILLAGER_FOSSIL = ModBlocks.registerRareBlock("villager_fossil", () -> new VillagerFossilBlock(BlockBehaviour.Properties.of().mapColor(MapColor.SAND).instrument(NoteBlockInstrument.XYLOPHONE).requiresCorrectToolForDrops().strength(2.0f).sound(SoundType.BONE_BLOCK).lightLevel(state -> (Integer)state.getValue((Property)VillagerFossilBlock.INVENTORY_LUMINANCE))));
    public static final RegistrySupplier<Block> VILLAGER_FOSSIL_HEAD = ModBlocks.registerRareBlock("villager_fossil_head", () -> new VillagerFossilHeadBlock(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.SKELETON).strength(1.0f).pushReaction(PushReaction.DESTROY).sound(SoundType.BONE_BLOCK)));
    public static final RegistrySupplier<Block> VILLAGER_FOSSIL_BODY = ModBlocks.registerRareBlock("villager_fossil_body", () -> new VillagerFossilBodyBlock(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.SKELETON).strength(1.0f).pushReaction(PushReaction.DESTROY).sound(SoundType.BONE_BLOCK)));
    public static final RegistrySupplier<Block> OCELOT_FOSSIL = ModBlocks.registerRareBlock("ocelot_fossil", () -> new OcelotFossilBlock(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.SKELETON).strength(1.0f).pushReaction(PushReaction.DESTROY).sound(SoundType.BONE_BLOCK)));
    public static final RegistrySupplier<Block> OCELOT_FOSSIL_HEAD = ModBlocks.registerRareBlock("ocelot_fossil_head", () -> new OcelotFossilHeadBlock(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.SKELETON).strength(1.0f).pushReaction(PushReaction.DESTROY).sound(SoundType.BONE_BLOCK)));
    public static final RegistrySupplier<Block> OCELOT_FOSSIL_BODY = ModBlocks.registerRareBlock("ocelot_fossil_body", () -> new OcelotFossilBodyBlock(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.SKELETON).strength(1.0f).pushReaction(PushReaction.DESTROY).sound(SoundType.BONE_BLOCK)));
    public static final RegistrySupplier<Block> GUARDIAN_FOSSIL = ModBlocks.registerRareBlock("guardian_fossil", () -> new GuardianFossilBlock(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.SKELETON).strength(1.0f).pushReaction(PushReaction.DESTROY).sound(SoundType.BONE_BLOCK)));
    public static final RegistrySupplier<Block> GUARDIAN_FOSSIL_HEAD = ModBlocks.registerRareBlock("guardian_fossil_head", () -> new GuardianFossilHeadBlock(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.SKELETON).strength(1.0f).pushReaction(PushReaction.DESTROY).sound(SoundType.BONE_BLOCK)));
    public static final RegistrySupplier<Block> GUARDIAN_FOSSIL_BODY = ModBlocks.registerRareBlock("guardian_fossil_body", () -> new GuardianFossilBodyBlock(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.SKELETON).strength(1.0f).pushReaction(PushReaction.DESTROY).sound(SoundType.BONE_BLOCK)));
    public static final RegistrySupplier<Block> SHEEP_FOSSIL = ModBlocks.registerRareBlock("sheep_fossil", () -> new SheepFossilBlock(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.SKELETON).strength(1.0f).pushReaction(PushReaction.DESTROY).sound(SoundType.BONE_BLOCK)));
    public static final RegistrySupplier<Block> SHEEP_FOSSIL_HEAD = ModBlocks.registerRareBlock("sheep_fossil_head", () -> new SheepFossilHeadBlock(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.SKELETON).strength(1.0f).pushReaction(PushReaction.DESTROY).sound(SoundType.BONE_BLOCK)));
    public static final RegistrySupplier<Block> SHEEP_FOSSIL_BODY = ModBlocks.registerRareBlock("sheep_fossil_body", () -> new SheepFossilBodyBlock(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.SKELETON).strength(1.0f).pushReaction(PushReaction.DESTROY).sound(SoundType.BONE_BLOCK)));
    public static final RegistrySupplier<Block> CHICKEN_FOSSIL = ModBlocks.registerRareBlock("chicken_fossil", () -> new ChickenFossilBlock(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.SKELETON).strength(1.0f).pushReaction(PushReaction.DESTROY).sound(SoundType.BONE_BLOCK)));
    public static final RegistrySupplier<Block> CHICKEN_FOSSIL_HEAD = ModBlocks.registerRareBlock("chicken_fossil_head", () -> new ChickenFossilHeadBlock(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.SKELETON).strength(1.0f).pushReaction(PushReaction.DESTROY).sound(SoundType.BONE_BLOCK)));
    public static final RegistrySupplier<Block> CHICKEN_FOSSIL_BODY = ModBlocks.registerRareBlock("chicken_fossil_body", () -> new ChickenFossilBodyBlock(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.SKELETON).strength(1.0f).pushReaction(PushReaction.DESTROY).sound(SoundType.BONE_BLOCK)));
    public static final RegistrySupplier<Block> CREEPER_FOSSIL = ModBlocks.registerRareBlock("creeper_fossil", () -> new CreeperFossilBlock(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.SKELETON).strength(1.0f).pushReaction(PushReaction.DESTROY).sound(SoundType.BONE_BLOCK)));
    public static final RegistrySupplier<Block> CREEPER_FOSSIL_HEAD = ModBlocks.registerRareBlock("creeper_fossil_head", () -> new CreeperFossilHeadBlock(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.SKELETON).strength(1.0f).pushReaction(PushReaction.DESTROY).sound(SoundType.BONE_BLOCK)));
    public static final RegistrySupplier<Block> CREEPER_FOSSIL_BODY = ModBlocks.registerRareBlock("creeper_fossil_body", () -> new CreeperFossilBodyBlock(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.SKELETON).strength(1.0f).pushReaction(PushReaction.DESTROY).sound(SoundType.BONE_BLOCK)));
    public static final RegistrySupplier<Block> WOLF_FOSSIL = ModBlocks.registerRareBlock("wolf_fossil", () -> new WolfFossilBlock(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.SKELETON).strength(1.0f).pushReaction(PushReaction.DESTROY).sound(SoundType.BONE_BLOCK)));
    public static final RegistrySupplier<Block> WOLF_FOSSIL_HEAD = ModBlocks.registerRareBlock("wolf_fossil_head", () -> new WolfFossilHeadBlock(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.SKELETON).strength(1.0f).pushReaction(PushReaction.DESTROY).sound(SoundType.BONE_BLOCK)));
    public static final RegistrySupplier<Block> WOLF_FOSSIL_BODY = ModBlocks.registerRareBlock("wolf_fossil_body", () -> new WolfFossilBodyBlock(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.SKELETON).strength(1.0f).pushReaction(PushReaction.DESTROY).sound(SoundType.BONE_BLOCK)));
    public static final WoodType ROTTEN_WOOD_TYPE = ModBlocks.registerWoodType("rotten_wood");
    public static final BlockSetType ROTTEN_WOOD_BLOCKSET = ModBlocks.registerBlockSetType("rotten_wood");
    public static final RegistrySupplier<Block> ROTTEN_LOG = ModBlocks.registerBlock("rotten_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).instrument(NoteBlockInstrument.BASS).strength(2.0f).ignitedByLava().sound(SoundType.STEM)));
    public static final RegistrySupplier<Block> ROTTEN_PLANKS = ModBlocks.registerBlock("rotten_planks", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).instrument(NoteBlockInstrument.BASS).strength(2.0f).ignitedByLava().sound(SoundType.STEM)));
    public static final RegistrySupplier<Block> ROTTEN_SLAB = ModBlocks.registerBlock("rotten_slab", () -> new SlabBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava().sound(SoundType.STEM)));
    public static final RegistrySupplier<Block> ROTTEN_STAIRS = ModBlocks.registerBlock("rotten_stairs", () -> new StairBlock(((Block)ROTTEN_PLANKS.get()).defaultBlockState(), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava().sound(SoundType.STEM)));
    public static final RegistrySupplier<Block> ROTTEN_FENCE = ModBlocks.registerBlock("rotten_fence", () -> new FenceBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).forceSolidOn().instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava().sound(SoundType.STEM)));
    public static final RegistrySupplier<Block> ROTTEN_FENCE_GATE = ModBlocks.registerBlock("rotten_fence_gate", () -> new FenceGateBlock(ROTTEN_WOOD_TYPE, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).forceSolidOn().instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).ignitedByLava().sound(SoundType.STEM)));
    public static final RegistrySupplier<Block> ROTTEN_TRAPDOOR = ModBlocks.registerBlock("rotten_trapdoor", () -> new TrapDoorBlock(ROTTEN_WOOD_BLOCKSET, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().isValidSpawn((state, getter, pos, entityType) -> false).ignitedByLava().sound(SoundType.STEM)));
    public static final RegistrySupplier<Block> ROTTEN_DOOR = ModBlocks.registerBlock("rotten_door", () -> new DoorBlock(ROTTEN_WOOD_BLOCKSET, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().ignitedByLava().pushReaction(PushReaction.DESTROY).sound(SoundType.STEM)));
    public static final RegistrySupplier<Block> ROTTEN_PRESSURE_PLATE = ModBlocks.registerBlock("rotten_pressure_plate", () -> new PressurePlateBlock(ROTTEN_WOOD_BLOCKSET, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(0.5f).ignitedByLava().pushReaction(PushReaction.DESTROY).sound(SoundType.STEM)));
    public static final RegistrySupplier<Block> INFESTED_MUD_BRICKS = ModBlocks.registerBlock("infested_mud_bricks", () -> new InfestedBlock(Blocks.MUD_BRICKS, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_LIGHT_GRAY).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 3.0f).sound(SoundType.MUD_BRICKS)));
    public static final RegistrySupplier<Block> CRACKED_MUD_BRICKS = ModBlocks.registerBlock("cracked_mud_bricks", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_LIGHT_GRAY).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 3.0f).sound(SoundType.MUD_BRICKS)));
    public static final RegistrySupplier<Block> CRACKED_MUD_BRICK_SLAB = ModBlocks.registerBlock("cracked_mud_brick_slab", () -> new SlabBlock(BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_LIGHT_GRAY).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 3.0f).sound(SoundType.MUD_BRICKS)));
    public static final RegistrySupplier<Block> CRACKED_MUD_BRICK_STAIRS = ModBlocks.registerBlock("cracked_mud_brick_stairs", () -> new StairBlock(((Block)CRACKED_MUD_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_LIGHT_GRAY).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 3.0f).sound(SoundType.MUD_BRICKS)));
    public static final RegistrySupplier<Block> ARCHEOLOGY_TABLE = ModBlocks.registerBlock("archeology_table", () -> new ArchelogyTable(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(2.5f).sound(SoundType.WOOD).ignitedByLava()));
    public static final RegistrySupplier<Block> LOOT_VASE = ModBlocks.registerBlock("loot_vase", () -> new LootVaseBlock(BlockBehaviour.Properties.of().instabreak().noOcclusion().pushReaction(PushReaction.DESTROY).sound(SoundType.DECORATED_POT)));
    public static final RegistrySupplier<Block> VASE = ModBlocks.registerBlock("vase", () -> new VaseBlock(BlockBehaviour.Properties.of().instabreak().noOcclusion().pushReaction(PushReaction.DESTROY).sound(SoundType.DECORATED_POT)));
    public static final RegistrySupplier<Block> LOOT_VASE_CREEPER = ModBlocks.registerBlock("loot_vase_creeper", () -> new LootVaseBlock(BlockBehaviour.Properties.of().instabreak().noOcclusion().pushReaction(PushReaction.DESTROY).sound(SoundType.DECORATED_POT)));
    public static final RegistrySupplier<Block> VASE_CREEPER = ModBlocks.registerBlock("vase_creeper", () -> new VaseBlock(BlockBehaviour.Properties.of().instabreak().noOcclusion().pushReaction(PushReaction.DESTROY).sound(SoundType.DECORATED_POT)));
    public static final RegistrySupplier<Block> LOOT_VASE_GREEN = ModBlocks.registerBlock("loot_vase_green", () -> new LootVaseBlock(BlockBehaviour.Properties.of().instabreak().noOcclusion().pushReaction(PushReaction.DESTROY).sound(SoundType.DECORATED_POT)));
    public static final RegistrySupplier<Block> VASE_GREEN = ModBlocks.registerBlock("vase_green", () -> new VaseBlock(BlockBehaviour.Properties.of().instabreak().noOcclusion().pushReaction(PushReaction.DESTROY).sound(SoundType.DECORATED_POT)));
    public static final RegistrySupplier<Block> EVOKER_TRAP = ModBlocks.registerBlock("evoker_trap", () -> new EvokerTrapBlock(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).pushReaction(PushReaction.BLOCK).strength(20.0f).requiresCorrectToolForDrops()));
    public static final RegistrySupplier<Block> GROWTH_TOTEM = ModBlocks.registerRareBlock("growth_totem", () -> new GrowthTotemBlock((Holder<MobEffect>)MobEffects.GLOWING, 15, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollission().instabreak().pushReaction(PushReaction.DESTROY).sound(SoundType.AMETHYST).offsetType(BlockBehaviour.OffsetType.NONE).lightLevel(state -> 15)));
    public static final RegistrySupplier<Block> RADIANCE_TOTEM = ModBlocks.registerRareBlock("radiance_totem", () -> new RadianceTotemBlock(BlockBehaviour.Properties.of().mapColor(MapColor.GOLD).forceSolidOn().requiresCorrectToolForDrops().strength(3.5f).sound(SoundType.LANTERN).lightLevel(p_152677_ -> 15).noOcclusion().pushReaction(PushReaction.DESTROY)));

    public static boolean isFossil(Block block) {
        return block instanceof FossilBaseBodyBlock || block instanceof FossilBaseWithEntityBlock || block instanceof FossilBaseHeadBlock || block instanceof FossilBaseBlock;
    }

    private static <T extends Block> RegistrySupplier<T> registerBlock(String name, Supplier<T> block) {
        return ModBlocks.registerBlock(name, block, null);
    }

    private static <T extends Block> RegistrySupplier<T> registerRareBlock(String name, Supplier<T> block) {
        return ModBlocks.registerBlock(name, block, Rarity.UNCOMMON);
    }

    private static <T extends Block> RegistrySupplier<T> registerBlock(String name, Supplier<T> block, Rarity rarity) {
        RegistrySupplier toReturn = BLOCKS.register(BACommon.createResource(name), block);
        ModBlocks.registerBlockItem(name, toReturn, rarity);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, RegistrySupplier<T> block, Rarity rarity) {
        ModItems.ITEMS.register(BACommon.createResource(name), () -> new BlockItem((Block)block.get(), rarity != null ? new Item.Properties().rarity(rarity) : new Item.Properties()));
    }

    private static WoodType registerWoodType(String id) {
        return WoodType.register((WoodType)new WoodType("betterarcheology." + id, new BlockSetType(id)));
    }

    private static BlockSetType registerBlockSetType(String id) {
        return BlockSetType.register((BlockSetType)new BlockSetType(id));
    }

    public static void register() {
        BACommon.logRegistryEvent(BLOCKS);
    }
}

