/*
 * Decompiled with CFR 0.152.
 */
package artifacts.mixin.item.pocketpiston.client;

import artifacts.extensions.pocketpiston.LivingEntityExtensions;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
implements LivingEntityExtensions {
    @Unique
    private static final int RETRACTION_DURATION = 2;
    @Unique
    private static final int RETRACTION_DELAY = 4;
    @Shadow
    public int swingTime;
    @Unique
    private float artifacts$pocketPistonLength;
    @Unique
    private int artifacts$pocketPistonTimeRemaining;

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void updatePocketPistonLength(CallbackInfo ci) {
        float d = (this.artifacts$pocketPistonTimeRemaining < 2 ? -1.0f : 1.0f) / 2.0f;
        this.artifacts$pocketPistonLength = Math.max(0.0f, Math.min(1.0f, this.artifacts$pocketPistonLength + d));
        if (this.swingTime != 0) {
            this.artifacts$pocketPistonTimeRemaining = 6;
        }
        if (this.artifacts$pocketPistonTimeRemaining > 0) {
            --this.artifacts$pocketPistonTimeRemaining;
        }
    }

    @Override
    @Unique
    public float artifacts$getPocketPistonLength() {
        Minecraft minecraft = Minecraft.getInstance();
        float partialTicks = minecraft.getTimer().getGameTimeDeltaPartialTick(true);
        float d = ((float)this.artifacts$pocketPistonTimeRemaining + partialTicks < 2.0f ? -1.0f : 1.0f) / 2.0f;
        return Math.max(0.0f, Math.min(1.0f, this.artifacts$pocketPistonLength + d * partialTicks));
    }
}

