/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.attributes;

import com.google.common.collect.Multimap;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.slot.SlotType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;

public class SlotAttribute
extends Attribute {
    private static final Map<String, Holder<Attribute>> CACHED_ATTRIBUTES = new HashMap<String, Holder<Attribute>>();
    private final String slotName;

    protected SlotAttribute(String slotName) {
        super(slotName, 0.0);
        this.slotName = slotName;
    }

    public String slotName() {
        return this.slotName;
    }

    @Deprecated(forRemoval=true)
    public static SlotAttribute getSlotAttribute(SlotType slotType) {
        return SlotAttribute.getSlotAttribute(slotType.name());
    }

    @Deprecated(forRemoval=true)
    public static SlotAttribute getSlotAttribute(String slotName) {
        return (SlotAttribute)((Object)SlotAttribute.getAttributeHolder(slotName).value());
    }

    public static Holder<Attribute> getAttributeHolder(SlotType slotType) {
        return SlotAttribute.getAttributeHolder(slotType.name());
    }

    public static Holder<Attribute> getAttributeHolder(String slotName) {
        return CACHED_ATTRIBUTES.computeIfAbsent(slotName, string -> Holder.direct((Object)((Object)new SlotAttribute(slotName))));
    }

    public static void addSlotModifier(Multimap<Holder<Attribute>, AttributeModifier> map, SlotType slotType, ResourceLocation location, double amount, AttributeModifier.Operation operation) {
        SlotAttribute.addSlotModifier(map, slotType.name(), location, amount, operation);
    }

    public static void addSlotModifier(Multimap<Holder<Attribute>, AttributeModifier> map, String slot, ResourceLocation location, double amount, AttributeModifier.Operation operation) {
        map.put(SlotAttribute.getAttributeHolder(slot), (Object)new AttributeModifier(location, amount, operation));
    }

    public static void addSlotAttribute(AccessoryAttributeBuilder builder, String targetSlot, ResourceLocation location, double amount, AttributeModifier.Operation operation, boolean isStackable) {
        if (isStackable) {
            builder.addStackable(SlotAttribute.getAttributeHolder(targetSlot), location, amount, operation);
        } else {
            builder.addExclusive(SlotAttribute.getAttributeHolder(targetSlot), location, amount, operation);
        }
    }

    public static void addSlotAttribute(ItemStack stack, String targetSlot, String boundSlot, ResourceLocation location, double amount, AttributeModifier.Operation operation, boolean isStackable) {
        AccessoriesAPI.addAttribute(stack, boundSlot, SlotAttribute.getAttributeHolder(targetSlot), location, amount, operation, isStackable);
    }
}

