/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client;

import com.mojang.blaze3d.vertex.PoseStack;
import io.wispforest.accessories.api.client.AccessoryRenderer;
import io.wispforest.accessories.api.client.ArmorRenderingExtension;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.mixin.client.LivingEntityRendererAccessor;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface AccessoryArmorRenderer
extends AccessoryRenderer {
    @Override
    default public <M extends LivingEntity> void render(ItemStack stack, SlotReference reference, PoseStack matrices, EntityModel<M> model, MultiBufferSource multiBufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        EntityRenderer entityRender = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)reference.entity());
        if (!(entityRender instanceof LivingEntityRendererAccessor)) {
            return;
        }
        LivingEntityRendererAccessor accessor = (LivingEntityRendererAccessor)entityRender;
        Item item = stack.getItem();
        if (!(item instanceof Equipable)) {
            return;
        }
        Equipable equipable = (Equipable)item;
        EquipmentSlot equipmentSlot = equipable.getEquipmentSlot();
        Optional<RenderLayer> possibleLayer = accessor.getLayers().stream().filter(renderLayer -> renderLayer instanceof ArmorRenderingExtension).findFirst();
        possibleLayer.ifPresent(layer -> ((ArmorRenderingExtension)layer).renderEquipmentStack(stack, matrices, multiBufferSource, reference.entity(), equipmentSlot, light, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch));
    }
}

