/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.networking.client;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.endec.NbtMapCarrier;
import io.wispforest.accessories.impl.AccessoriesHolderImpl;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.network.OwoNetChannel;
import io.wispforest.owo.serialization.RegistriesAttribute;
import java.util.HashSet;
import java.util.function.Function;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.Logger;

public record SyncEntireContainer(int entityId, NbtMapCarrier containerMap) {
    public static final StructEndec<SyncEntireContainer> ENDEC = StructEndecBuilder.of((StructField)Endec.VAR_INT.fieldOf("entityId", SyncEntireContainer::entityId), (StructField)NbtMapCarrier.ENDEC.fieldOf("containerTag", SyncEntireContainer::containerMap), SyncEntireContainer::new);
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void syncToAllTrackingAndSelf(ServerPlayer player) {
        SyncEntireContainer.syncTo((LivingEntity)player, channel -> {
            HashSet<ServerPlayer> set = new HashSet<ServerPlayer>(PlayerLookup.tracking((Entity)player));
            set.add(player);
            return channel.serverHandle(set);
        });
    }

    public static void syncTo(LivingEntity entity, Function<OwoNetChannel, OwoNetChannel.ServerHandle> handleCreator) {
        AccessoriesCapability capability = AccessoriesCapability.get(entity);
        if (capability == null) {
            return;
        }
        NbtMapCarrier carrier = NbtMapCarrier.of();
        ((AccessoriesHolderImpl)capability.getHolder()).write(carrier, SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.of((RegistryAccess)entity.level().registryAccess())}));
        handleCreator.apply(AccessoriesNetworking.CHANNEL).send((Record)new SyncEntireContainer(capability.entity().getId(), carrier));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handlePacket(SyncEntireContainer packet, Player player) {
        Level level = player.level();
        Entity entity = level.getEntity(packet.entityId());
        if (entity == null) {
            LOGGER.error("Unable to Sync Container Data for a given Entity as it is null on the Client! [EntityId: {}]", (Object)packet.entityId());
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        AccessoriesCapability capability = AccessoriesCapability.get(livingEntity);
        if (capability == null) {
            LOGGER.error("Unable to Sync Container Data for a given Entity as its Capability is null on the Client! [EntityId: {}]", (Object)packet.entityId());
            return;
        }
        AccessoriesHolderImpl holder = (AccessoriesHolderImpl)capability.getHolder();
        holder.read(packet.containerMap(), SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.of((RegistryAccess)level.registryAccess())}));
        holder.init(capability);
    }
}

