/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.mixin.mixins.client.music;

import com.mojang.blaze3d.audio.SoundBuffer;
import com.yungnickyoung.minecraft.ribbits.RibbitsCommon;
import com.yungnickyoung.minecraft.ribbits.client.sound.InstrumentSoundInstance;
import com.yungnickyoung.minecraft.ribbits.client.sound.PlayerInstrumentSoundInstance;
import com.yungnickyoung.minecraft.ribbits.client.sound.RibbitInstrumentSoundInstance;
import com.yungnickyoung.minecraft.ribbits.mixin.interfaces.client.IChannelDuck;
import com.yungnickyoung.minecraft.ribbits.mixin.interfaces.client.ISoundEngineDuck;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.client.sounds.SoundBufferLibrary;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={SoundEngine.class})
public class SoundEngineMixin
implements ISoundEngineDuck {
    @Shadow
    @Final
    private SoundBufferLibrary soundBuffers;
    @Shadow
    @Final
    private List<TickableSoundInstance> tickingSounds;

    @Inject(method={"play"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/sounds/SoundBufferLibrary;getCompleteBuffer(Lnet/minecraft/resources/ResourceLocation;)Ljava/util/concurrent/CompletableFuture;", shift=At.Shift.BEFORE)}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private void ribbits$handleRibbitsOffsetSounds(SoundInstance soundInstance, CallbackInfo ci, WeighedSoundEvents $$1x, ResourceLocation $$2x, Sound sound, float $$4x, float $$5x, SoundSource soundSource, float $$7x, float $$8x, SoundInstance.Attenuation attenuation, boolean $$10x, Vec3 $$11x, boolean $$14, boolean $$15, CompletableFuture $$16, ChannelAccess.ChannelHandle channelAccess) {
        if (soundInstance instanceof InstrumentSoundInstance) {
            InstrumentSoundInstance instrumentSoundInstance = (InstrumentSoundInstance)soundInstance;
            this.playInstrumentSound(sound, channelAccess, instrumentSoundInstance);
            ci.cancel();
        }
    }

    @Unique
    private void playInstrumentSound(Sound sound, ChannelAccess.ChannelHandle channelHandle, InstrumentSoundInstance instrumentSoundInstance) {
        List<InstrumentSoundInstance> soundsToStop = this.tickingSounds.stream().filter(instance -> instance instanceof InstrumentSoundInstance).map(instance -> (InstrumentSoundInstance)((Object)instance)).filter(instance -> instance.isForSameEntity(instrumentSoundInstance)).toList();
        soundsToStop.forEach(InstrumentSoundInstance::stopSound);
        this.soundBuffers.getCompleteBuffer(sound.getPath()).thenAccept(soundBuffer -> channelHandle.execute(channel -> {
            if (instrumentSoundInstance.getTicksOffset() == -1) {
                Optional<Integer> existingSoundSourceId = this.tickingSounds.stream().filter(instance -> instance instanceof InstrumentSoundInstance && !instance.isStopped() && !instance.equals((Object)instrumentSoundInstance)).map(instance -> ((InstrumentSoundInstance)((Object)((Object)((Object)instance)))).getSourceId()).findAny();
                if (existingSoundSourceId.isPresent()) {
                    ((IChannelDuck)channel).ribbits$attachStaticBufferWithByteOffset((SoundInstance)instrumentSoundInstance, (SoundBuffer)soundBuffer, existingSoundSourceId.get());
                } else {
                    if (instrumentSoundInstance instanceof RibbitInstrumentSoundInstance) {
                        RibbitsCommon.LOGGER.debug("Tried to play Ribbit sound with byte offset, but no existing sound was found! Playing from the start instead...");
                    }
                    ((IChannelDuck)channel).ribbits$attachStaticBufferWithTickOffset((SoundInstance)instrumentSoundInstance, (SoundBuffer)soundBuffer, 0);
                }
            } else {
                ((IChannelDuck)channel).ribbits$attachStaticBufferWithTickOffset((SoundInstance)instrumentSoundInstance, (SoundBuffer)soundBuffer, instrumentSoundInstance.getTicksOffset());
            }
            channel.play();
        }));
        this.tickingSounds.add((TickableSoundInstance)instrumentSoundInstance);
    }

    @Override
    @Unique
    public void ribbits$stopRibbitsMusic(UUID ribbitEntityId) {
        List<RibbitInstrumentSoundInstance> soundsToStop = this.tickingSounds.stream().filter(instance -> instance instanceof RibbitInstrumentSoundInstance).map(instance -> (RibbitInstrumentSoundInstance)((Object)instance)).filter(instance -> instance.getRibbit().getUUID().equals(ribbitEntityId)).toList();
        soundsToStop.forEach(InstrumentSoundInstance::stopSound);
    }

    @Override
    @Unique
    public void ribbits$stopMaraca(UUID playerId) {
        List<PlayerInstrumentSoundInstance> soundsToStop = this.tickingSounds.stream().filter(instance -> instance instanceof PlayerInstrumentSoundInstance).map(instance -> (PlayerInstrumentSoundInstance)((Object)instance)).filter(instance -> instance.getPlayer().getUUID().equals(playerId)).toList();
        soundsToStop.forEach(InstrumentSoundInstance::stopSound);
    }
}

