/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.module;

import com.yungnickyoung.minecraft.ribbits.RibbitsCommon;
import com.yungnickyoung.minecraft.ribbits.data.RibbitProfession;
import com.yungnickyoung.minecraft.yungsapi.api.autoregister.AutoRegister;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

@AutoRegister(value="ribbits")
public class RibbitProfessionModule {
    private static final Map<ResourceLocation, RibbitProfession> PROFESSION_REGISTRY = new HashMap<ResourceLocation, RibbitProfession>();
    public static final RibbitProfession NITWIT = RibbitProfessionModule.register("nitwit", "geo/nitwit_ribbit.geo.json");
    public static final RibbitProfession GARDENER = RibbitProfessionModule.register("gardener", "geo/gardener_ribbit.geo.json");
    public static final RibbitProfession SORCERER = RibbitProfessionModule.register("sorcerer", "geo/sorcerer_ribbit.geo.json");
    public static final RibbitProfession FISHERMAN = RibbitProfessionModule.register("fisherman", "geo/fisherman_ribbit.geo.json");
    public static final RibbitProfession MERCHANT = RibbitProfessionModule.register("merchant", "geo/merchant_ribbit.geo.json");

    public static RibbitProfession register(String name, String modelPath) {
        ResourceLocation id = RibbitsCommon.id(name);
        RibbitProfession profession = new RibbitProfession(id, RibbitsCommon.id(modelPath));
        PROFESSION_REGISTRY.put(id, profession);
        return profession;
    }

    @Nullable
    public static RibbitProfession getProfession(ResourceLocation id) {
        return PROFESSION_REGISTRY.get(id);
    }

    public static RibbitProfession getRandomProfession() {
        Random random = new Random();
        List<RibbitProfession> professionList = PROFESSION_REGISTRY.values().stream().toList();
        return professionList.get(random.nextInt(professionList.size()));
    }

    @AutoRegister(value="_ignored")
    public static void initRibbitsProfessions() {
        RibbitsCommon.LOGGER.info("Registering Ribbit professions...");
    }
}

