/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.features;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.countered.settlementroads.config.ModConfig;
import net.countered.settlementroads.features.config.RoadFeatureConfig;
import net.countered.settlementroads.features.decoration.Decoration;
import net.countered.settlementroads.features.decoration.DistanceSignDecoration;
import net.countered.settlementroads.features.decoration.FenceWaypointDecoration;
import net.countered.settlementroads.features.decoration.LamppostDecoration;
import net.countered.settlementroads.features.decoration.RoadStructures;
import net.countered.settlementroads.features.roadlogic.RoadPathCalculator;
import net.countered.settlementroads.helpers.Records;
import net.countered.settlementroads.helpers.StructureConnector;
import net.countered.settlementroads.persistence.attachments.WorldDataAttachment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoadFeature
extends Feature<RoadFeatureConfig> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"settlement-roads");
    public static final Set<Block> dontPlaceHere = new HashSet<Block>();
    public static int chunksForLocatingCounter;
    public static final ResourceKey<PlacedFeature> ROAD_FEATURE_PLACED_KEY;
    public static final ResourceKey<ConfiguredFeature<?, ?>> ROAD_FEATURE_KEY;
    public static final Feature<RoadFeatureConfig> ROAD_FEATURE;

    public RoadFeature(Codec<RoadFeatureConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<RoadFeatureConfig> context) {
        if (RoadPathCalculator.heightCache.size() > 100000) {
            RoadPathCalculator.heightCache.clear();
        }
        ServerLevel serverWorld = context.level().getLevel();
        WorldGenLevel structureWorldAccess = context.level();
        Records.StructureLocationData structureLocationData = (Records.StructureLocationData)serverWorld.getAttached(WorldDataAttachment.STRUCTURE_LOCATIONS);
        if (structureLocationData == null) {
            return false;
        }
        List<BlockPos> villageLocations = structureLocationData.structureLocations();
        this.tryFindNewStructureConnection(villageLocations, serverWorld);
        HashSet<Decoration> roadDecorationCache = new HashSet<Decoration>();
        this.runRoadLogic(structureWorldAccess, context, roadDecorationCache);
        RoadStructures.tryPlaceDecorations(roadDecorationCache);
        return true;
    }

    private void tryFindNewStructureConnection(List<BlockPos> villageLocations, ServerLevel serverWorld) {
        if ((villageLocations == null || villageLocations.size() < ModConfig.maxLocatingCount) && ++chunksForLocatingCounter > 300) {
            List connectionList = (List)serverWorld.getAttached(WorldDataAttachment.CONNECTED_STRUCTURES);
            serverWorld.getServer().execute(() -> StructureConnector.cacheNewConnection(serverWorld, true));
            chunksForLocatingCounter = 1;
        }
    }

    private void runRoadLogic(WorldGenLevel structureWorldAccess, FeaturePlaceContext<RoadFeatureConfig> context, Set<Decoration> roadDecorationPlacementPositions) {
        int averagingRadius = ModConfig.averagingRadius;
        List roadDataList = (List)structureWorldAccess.getLevel().getAttached(WorldDataAttachment.ROAD_DATA_LIST);
        if (roadDataList == null) {
            return;
        }
        ChunkPos currentChunkPos = new ChunkPos(context.origin());
        HashSet<BlockPos> posAlreadyContainsSegment = new HashSet<BlockPos>();
        for (Records.RoadData data : roadDataList) {
            int roadType = data.roadType();
            List<BlockState> materials = data.materials();
            List<Records.RoadSegmentPlacement> segmentList = data.roadSegmentList();
            List<BlockPos> middlePositions = segmentList.stream().map(Records.RoadSegmentPlacement::middlePos).toList();
            int segmentIndex = 0;
            for (int i = 2; i < segmentList.size() - 2; ++i) {
                ChunkPos middleChunkPos;
                if (posAlreadyContainsSegment.contains(middlePositions.get(i))) continue;
                Records.RoadSegmentPlacement segment = segmentList.get(i);
                BlockPos segmentMiddlePos = segment.middlePos();
                if (++segmentIndex < 60 || segmentIndex > segmentList.size() - 60 || !(middleChunkPos = new ChunkPos(segmentMiddlePos)).equals((Object)currentChunkPos)) continue;
                BlockPos prevPos = middlePositions.get(i - 2);
                BlockPos nextPos = middlePositions.get(i + 2);
                ArrayList<Double> heights = new ArrayList<Double>();
                for (int j = i - averagingRadius; j <= i + averagingRadius; ++j) {
                    if (j < 0 || j >= middlePositions.size()) continue;
                    BlockPos samplePos = middlePositions.get(j);
                    double y = structureWorldAccess.getHeight(Heightmap.Types.WORLD_SURFACE_WG, samplePos.getX(), samplePos.getZ());
                    heights.add(y);
                }
                int averageY = (int)Math.round(heights.stream().mapToDouble(Double::doubleValue).average().orElse(segmentMiddlePos.getY()));
                BlockPos averagedPos = new BlockPos(segmentMiddlePos.getX(), averageY, segmentMiddlePos.getZ());
                RandomSource random = context.random();
                if (!ModConfig.placeWaypoints) {
                    for (BlockPos widthBlock : segment.positions()) {
                        BlockPos correctedYPos = new BlockPos(widthBlock.getX(), averageY, widthBlock.getZ());
                        this.placeOnSurface(structureWorldAccess, correctedYPos, materials, roadType, random);
                    }
                }
                this.addDecoration(structureWorldAccess, roadDecorationPlacementPositions, averagedPos, segmentIndex, nextPos, prevPos, middlePositions, roadType, random);
                posAlreadyContainsSegment.add(segmentMiddlePos);
            }
        }
    }

    private void addDecoration(WorldGenLevel structureWorldAccess, Set<Decoration> roadDecorationPlacementPositions, BlockPos placePos, int segmentIndex, BlockPos nextPos, BlockPos prevPos, List<BlockPos> middleBlockPositions, int roadType, RandomSource random) {
        boolean isEnd;
        int dz;
        BlockPos surfacePos = placePos.atY(structureWorldAccess.getHeight(Heightmap.Types.WORLD_SURFACE_WG, placePos.getX(), placePos.getZ()));
        BlockState blockStateAtPos = structureWorldAccess.getBlockState(surfacePos.below());
        if (blockStateAtPos.equals(Blocks.WATER.defaultBlockState()) && segmentIndex % ModConfig.distanceBetweenBuoys == 0) {
            RoadStructures.placeBuoy(structureWorldAccess, surfacePos);
        }
        if (ModConfig.placeWaypoints) {
            if (segmentIndex % 25 == 0) {
                roadDecorationPlacementPositions.add(new FenceWaypointDecoration(surfacePos, structureWorldAccess));
            }
            return;
        }
        int dx = nextPos.getX() - prevPos.getX();
        double length = Math.sqrt(dx * dx + (dz = nextPos.getZ() - prevPos.getZ()) * dz);
        int normDx = length != 0.0 ? (int)Math.round((double)dx / length) : 0;
        int normDz = length != 0.0 ? (int)Math.round((double)dz / length) : 0;
        Vec3i directionVector = new Vec3i(normDx, 0, normDz);
        Vec3i orthogonalVector = new Vec3i(-directionVector.getZ(), 0, directionVector.getX());
        boolean bl = isEnd = segmentIndex != middleBlockPositions.size() - 65;
        if (segmentIndex == 65 || segmentIndex == middleBlockPositions.size() - 65) {
            BlockPos shiftedPos = isEnd ? placePos.offset(orthogonalVector.multiply(2)) : placePos.subtract(orthogonalVector.multiply(2));
            roadDecorationPlacementPositions.add(new DistanceSignDecoration(shiftedPos, orthogonalVector, structureWorldAccess, isEnd, String.valueOf(middleBlockPositions.size())));
        } else if (segmentIndex % 59 == 0) {
            boolean leftRoadSide = random.nextBoolean();
            BlockPos shiftedPos = leftRoadSide ? placePos.offset(orthogonalVector.multiply(2)) : placePos.subtract(orthogonalVector.multiply(2));
            if (Math.abs((shiftedPos = shiftedPos.atY(structureWorldAccess.getHeight(Heightmap.Types.WORLD_SURFACE_WG, shiftedPos.getX(), shiftedPos.getZ()))).getY() - placePos.getY()) > 1) {
                return;
            }
            if (roadType == 0) {
                roadDecorationPlacementPositions.add(new LamppostDecoration(shiftedPos, orthogonalVector, structureWorldAccess, leftRoadSide));
            } else {
                roadDecorationPlacementPositions.add(new FenceWaypointDecoration(shiftedPos, structureWorldAccess));
            }
        }
    }

    private void placeOnSurface(WorldGenLevel structureWorldAccess, BlockPos placePos, List<BlockState> material, int natural, RandomSource random) {
        double naturalBlockChance = 0.5;
        BlockPos surfacePos = placePos;
        if (natural == 1 || ModConfig.averagingRadius == 0) {
            surfacePos = structureWorldAccess.getHeightmapPos(Heightmap.Types.WORLD_SURFACE_WG, placePos);
        }
        BlockState blockStateAtPos = structureWorldAccess.getBlockState(structureWorldAccess.getHeightmapPos(Heightmap.Types.WORLD_SURFACE_WG, surfacePos).below());
        if (natural == 0 || random.nextDouble() < naturalBlockChance) {
            this.placeRoadBlock(structureWorldAccess, blockStateAtPos, surfacePos, material, random);
        }
    }

    private void placeRoadBlock(WorldGenLevel structureWorldAccess, BlockState blockStateAtPos, BlockPos surfacePos, List<BlockState> materials, RandomSource deterministicRandom) {
        BlockState blockStateUp;
        if (!this.placeAllowedCheck(blockStateAtPos.getBlock()) || !structureWorldAccess.getBlockState(surfacePos.below()).canOcclude() && !structureWorldAccess.getBlockState(surfacePos.below(2)).canOcclude()) {
            return;
        }
        BlockState material = materials.get(deterministicRandom.nextInt(materials.size()));
        this.setBlock((LevelWriter)structureWorldAccess, surfacePos.below(), material);
        for (int i = 0; !(i >= 3 || (blockStateUp = structureWorldAccess.getBlockState(surfacePos.above(i))).getBlock().equals(Blocks.AIR) || blockStateUp.is(BlockTags.LOGS) || blockStateUp.is(BlockTags.FENCES)); ++i) {
            this.setBlock((LevelWriter)structureWorldAccess, surfacePos.above(i), Blocks.AIR.defaultBlockState());
        }
        BlockPos belowPos1 = surfacePos.below(2);
        BlockState belowState1 = structureWorldAccess.getBlockState(belowPos1);
        if (belowState1.getBlock().equals(Blocks.GRASS_BLOCK)) {
            this.setBlock((LevelWriter)structureWorldAccess, belowPos1, Blocks.DIRT.defaultBlockState());
        }
    }

    private boolean placeAllowedCheck(Block blockToCheck) {
        return !dontPlaceHere.contains(blockToCheck) && !blockToCheck.defaultBlockState().is(BlockTags.LEAVES) && !blockToCheck.defaultBlockState().is(BlockTags.LOGS) && !blockToCheck.defaultBlockState().is(BlockTags.UNDERWATER_BONEMEALS) && !blockToCheck.defaultBlockState().is(BlockTags.WOODEN_FENCES) && !blockToCheck.defaultBlockState().is(BlockTags.PLANKS);
    }

    static {
        dontPlaceHere.add(Blocks.PACKED_ICE);
        dontPlaceHere.add(Blocks.ICE);
        dontPlaceHere.add(Blocks.BLUE_ICE);
        dontPlaceHere.add(Blocks.TALL_SEAGRASS);
        dontPlaceHere.add(Blocks.MANGROVE_ROOTS);
        chunksForLocatingCounter = 1;
        ROAD_FEATURE_PLACED_KEY = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"settlement-roads", (String)"road_feature_placed"));
        ROAD_FEATURE_KEY = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"settlement-roads", (String)"road_feature"));
        ROAD_FEATURE = new RoadFeature(RoadFeatureConfig.CODEC);
    }
}

