/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.features.decoration;

import java.util.Iterator;
import java.util.Set;
import net.countered.settlementroads.features.decoration.Decoration;
import net.countered.settlementroads.features.decoration.DistanceSignDecoration;
import net.countered.settlementroads.features.decoration.FenceWaypointDecoration;
import net.countered.settlementroads.features.decoration.LamppostDecoration;
import net.countered.settlementroads.features.decoration.util.WoodSelector;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;

public class RoadStructures {
    public static void tryPlaceDecorations(Set<Decoration> roadDecorationPlacementPositions) {
        if (roadDecorationPlacementPositions.isEmpty()) {
            return;
        }
        Iterator<Decoration> iterator = roadDecorationPlacementPositions.iterator();
        while (iterator.hasNext()) {
            Decoration roadDecoration = iterator.next();
            if (roadDecoration == null) continue;
            if (roadDecoration instanceof LamppostDecoration) {
                LamppostDecoration lamppostDecoration = (LamppostDecoration)roadDecoration;
                lamppostDecoration.setWoodType(WoodSelector.forBiome(lamppostDecoration.getWorld(), lamppostDecoration.getPos()));
                lamppostDecoration.place();
            }
            if (roadDecoration instanceof DistanceSignDecoration) {
                DistanceSignDecoration distanceSignDecoration = (DistanceSignDecoration)roadDecoration;
                distanceSignDecoration.setWoodType(WoodSelector.forBiome(distanceSignDecoration.getWorld(), distanceSignDecoration.getPos()));
                distanceSignDecoration.place();
            }
            if (roadDecoration instanceof FenceWaypointDecoration) {
                FenceWaypointDecoration fenceWaypointDecoration = (FenceWaypointDecoration)roadDecoration;
                fenceWaypointDecoration.setWoodType(WoodSelector.forBiome(fenceWaypointDecoration.getWorld(), fenceWaypointDecoration.getPos()));
                fenceWaypointDecoration.place();
            }
            iterator.remove();
        }
    }

    public static void placeBuoy(WorldGenLevel worldAccess, BlockPos surfacePos) {
        worldAccess.setBlock(surfacePos.below(), Blocks.SPRUCE_PLANKS.defaultBlockState(), 3);
        worldAccess.setBlock(surfacePos, Blocks.SPRUCE_FENCE.defaultBlockState(), 3);
    }
}

