/*
 * Decompiled with CFR 0.152.
 */
package net.countered.settlementroads.features.roadlogic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.countered.settlementroads.config.ModConfig;
import net.countered.settlementroads.features.config.RoadFeatureConfig;
import net.countered.settlementroads.features.roadlogic.RoadPathCalculator;
import net.countered.settlementroads.helpers.Records;
import net.countered.settlementroads.persistence.attachments.WorldDataAttachment;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;

public class Road {
    ServerLevel serverWorld;
    Records.StructureConnection structureConnection;
    RoadFeatureConfig context;

    public Road(ServerLevel serverWorld, Records.StructureConnection structureConnection, RoadFeatureConfig config) {
        this.serverWorld = serverWorld;
        this.structureConnection = structureConnection;
        this.context = config;
    }

    public void generateRoad(int maxSteps) {
        RandomSource random = RandomSource.create();
        int width = Road.getRandomWidth(random, this.context);
        int type = Road.allowedRoadTypes(random);
        if (type == -1) {
            return;
        }
        List<BlockState> material = type == 1 ? Road.getRandomNaturalRoadMaterials(random, this.context) : Road.getRandomArtificialRoadMaterials(random, this.context);
        BlockPos start = this.structureConnection.from();
        BlockPos end = this.structureConnection.to();
        List<Records.RoadSegmentPlacement> roadSegmentPlacementList = RoadPathCalculator.calculateAStarRoadPath(start, end, width, this.serverWorld, maxSteps);
        ArrayList<Records.RoadData> roadDataList = new ArrayList<Records.RoadData>((Collection)this.serverWorld.getAttachedOrCreate(WorldDataAttachment.ROAD_DATA_LIST, ArrayList::new));
        roadDataList.add(new Records.RoadData(width, type, material, roadSegmentPlacementList));
        this.serverWorld.setAttached(WorldDataAttachment.ROAD_DATA_LIST, roadDataList);
    }

    private static int allowedRoadTypes(RandomSource deterministicRandom) {
        if (ModConfig.allowArtificial && ModConfig.allowNatural) {
            return Road.getRandomRoadType(deterministicRandom);
        }
        if (ModConfig.allowArtificial) {
            return 0;
        }
        if (ModConfig.allowNatural) {
            return 1;
        }
        return -1;
    }

    private static int getRandomRoadType(RandomSource random) {
        return random.nextIntBetweenInclusive(0, 1);
    }

    private static List<BlockState> getRandomNaturalRoadMaterials(RandomSource random, RoadFeatureConfig config) {
        List<List<BlockState>> materialsList = config.getNaturalMaterials();
        return materialsList.get(random.nextInt(materialsList.size()));
    }

    private static List<BlockState> getRandomArtificialRoadMaterials(RandomSource random, RoadFeatureConfig config) {
        List<List<BlockState>> materialsList = config.getArtificialMaterials();
        return materialsList.get(random.nextInt(materialsList.size()));
    }

    private static int getRandomWidth(RandomSource random, RoadFeatureConfig config) {
        List<Integer> widthList = config.getWidths();
        return widthList.get(random.nextInt(widthList.size()));
    }
}

