/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib.builtinpacks;

import de.cristelknight.cristellib.CristelLib;
import de.cristelknight.cristellib.CristelLibExpectPlatform;
import de.cristelknight.cristellib.builtinpacks.BuiltinResourcePackSource;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.NotNull;

public class BuiltInDataPacks {
    private static final List<Tuple<Tuple<Component, PackResources>, Supplier<Boolean>>> list = new ArrayList<Tuple<Tuple<Component, PackResources>, Supplier<Boolean>>>();

    public static void registerAlwaysOnPack(ResourceLocation path, String modid, Component displayName) {
        BuiltInDataPacks.registerPack(path, modid, displayName, () -> true);
    }

    public static void registerPack(ResourceLocation path, String modid, Component displayName, Supplier<Boolean> supplier) {
        BuiltInDataPacks.registerPack(CristelLibExpectPlatform.registerBuiltinResourcePack(path, displayName, modid), displayName, supplier);
    }

    public static void registerPack(PackResources packResource, Component displayName, Supplier<Boolean> supplier) {
        list.add((Tuple<Tuple<Component, PackResources>, Supplier<Boolean>>)new Tuple((Object)new Tuple((Object)displayName, (Object)packResource), supplier));
    }

    public static void getPacks(Consumer<Pack> consumer) {
        if (list.isEmpty()) {
            return;
        }
        for (Tuple<Tuple<Component, PackResources>, Supplier<Boolean>> entry : list) {
            PackSelectionConfig info2;
            PackResources pack;
            if (!((Boolean)((Supplier)entry.getB()).get()).booleanValue() || (pack = (PackResources)((Tuple)entry.getA()).getB()).getNamespaces(PackType.SERVER_DATA).isEmpty()) continue;
            Component displayName = (Component)((Tuple)entry.getA()).getA();
            PackLocationInfo info = new PackLocationInfo(pack.packId(), displayName, (PackSource)new BuiltinResourcePackSource(), pack.knownPackInfo());
            Pack profile = Pack.readMetaAndCreate((PackLocationInfo)info, (Pack.ResourcesSupplier)new Pack.ResourcesSupplier(){

                @NotNull
                public PackResources openPrimary(PackLocationInfo var1) {
                    return pack;
                }

                @NotNull
                public PackResources openFull(PackLocationInfo var1, Pack.Metadata metadata) {
                    return pack;
                }
            }, (PackType)PackType.SERVER_DATA, (PackSelectionConfig)(info2 = new PackSelectionConfig(true, Pack.Position.TOP, false)));
            if (profile == null) {
                CristelLib.LOGGER.error("Pack Profile with display name: {} is null", (Object)displayName);
                return;
            }
            consumer.accept(profile);
        }
    }
}

