/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pickupnotifier.client.util;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import org.joml.Matrix4f;

public class TransparencyBuffer {
    private static final RenderTarget BUFFER_INSTANCE;
    private static int previousFramebuffer;

    public static void prepareExtraFramebuffer() {
        previousFramebuffer = GlStateManager.getBoundFramebuffer();
        BUFFER_INSTANCE.clear(Minecraft.ON_OSX);
        BUFFER_INSTANCE.bindWrite(false);
    }

    public static void preInject(float alpha) {
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
    }

    public static void drawExtraFramebuffer(GuiGraphics guiGraphics) {
        GlStateManager._glBindFramebuffer((int)36160, (int)previousFramebuffer);
        RenderSystem.setShaderTexture((int)0, (int)BUFFER_INSTANCE.getColorTextureId());
        Window window = Minecraft.getInstance().getWindow();
        TransparencyBuffer.blit(guiGraphics.pose(), 0, 0, window.getGuiScaledWidth(), window.getGuiScaledHeight(), 0.0f, TransparencyBuffer.BUFFER_INSTANCE.height, TransparencyBuffer.BUFFER_INSTANCE.width, -TransparencyBuffer.BUFFER_INSTANCE.height, TransparencyBuffer.BUFFER_INSTANCE.width, TransparencyBuffer.BUFFER_INSTANCE.height);
    }

    public static void blit(PoseStack poseStack, int x, int y, int width, int height, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        TransparencyBuffer.blit(poseStack, x, x + width, y, y + height, 0, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
    }

    private static void blit(PoseStack poseStack, int i, int j, int k, int l, int m, int n, int o, float f, float g, int p, int q) {
        TransparencyBuffer.innerBlit(poseStack.last().pose(), i, j, k, l, m, (f + 0.0f) / (float)p, (f + (float)n) / (float)p, (g + 0.0f) / (float)q, (g + (float)o) / (float)q);
    }

    private static void innerBlit(Matrix4f matrix, int x1, int x2, int y1, int y2, int blitOffset, float minU, float maxU, float minV, float maxV) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferBuilder.addVertex(matrix, (float)x1, (float)y1, (float)blitOffset).setUv(minU, minV);
        bufferBuilder.addVertex(matrix, (float)x1, (float)y2, (float)blitOffset).setUv(minU, maxV);
        bufferBuilder.addVertex(matrix, (float)x2, (float)y2, (float)blitOffset).setUv(maxU, maxV);
        bufferBuilder.addVertex(matrix, (float)x2, (float)y1, (float)blitOffset).setUv(maxU, minV);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
    }

    public static void postInject() {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void resizeDisplay() {
        Window window = Minecraft.getInstance().getWindow();
        BUFFER_INSTANCE.resize(window.getWidth(), window.getHeight(), Minecraft.ON_OSX);
    }

    static {
        Window window = Minecraft.getInstance().getWindow();
        BUFFER_INSTANCE = new TextureTarget(window.getWidth(), window.getHeight(), true, Minecraft.ON_OSX);
        BUFFER_INSTANCE.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
    }
}

