/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.mixin.common.StructureProcessorListAccessor;
import dev.worldgen.lithostitched.worldgen.LithostitchedCodecs;
import dev.worldgen.lithostitched.worldgen.modifier.Modifier;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;

public record AddProcessorListProcessorsModifier(HolderSet<StructureProcessorList> processorLists, StructureProcessorList processors) implements Modifier
{
    public static final MapCodec<AddProcessorListProcessorsModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LithostitchedCodecs.registrySet(Registries.PROCESSOR_LIST, "processor_lists").forGetter(AddProcessorListProcessorsModifier::processorLists), (App)StructureProcessorType.LIST_OBJECT_CODEC.fieldOf("processors").forGetter(AddProcessorListProcessorsModifier::processors)).apply((Applicative)instance, AddProcessorListProcessorsModifier::new));

    @Override
    public void applyModifier() {
        this.processorLists.stream().map(Holder::value).forEach(this::applyModifier);
    }

    public void applyModifier(StructureProcessorList processorList) {
        StructureProcessorListAccessor accessor = (StructureProcessorListAccessor)processorList;
        ArrayList<StructureProcessor> structureProcessors = new ArrayList<StructureProcessor>(processorList.list());
        structureProcessors.addAll(this.processors.list());
        accessor.setProcessors(structureProcessors);
    }

    @Override
    public Modifier.ModifierPhase getPhase() {
        return Modifier.ModifierPhase.ADD;
    }

    @Override
    public MapCodec<? extends Modifier> codec() {
        return CODEC;
    }
}

