/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.mixin.common.StructureSetAccessor;
import dev.worldgen.lithostitched.worldgen.LithostitchedCodecs;
import dev.worldgen.lithostitched.worldgen.modifier.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;

public record RemoveStructureSetEntriesModifier(HolderSet<StructureSet> structureSets, List<Holder<Structure>> entries) implements Modifier
{
    public static final MapCodec<RemoveStructureSetEntriesModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LithostitchedCodecs.registrySet(Registries.STRUCTURE_SET, "structure_sets").forGetter(RemoveStructureSetEntriesModifier::structureSets), (App)Structure.CODEC.listOf().fieldOf("structures").forGetter(RemoveStructureSetEntriesModifier::entries)).apply((Applicative)instance, RemoveStructureSetEntriesModifier::new));

    @Override
    public void applyModifier() {
        this.structureSets.stream().map(Holder::value).forEach(this::applyModifier);
    }

    private void applyModifier(StructureSet structureSet) {
        StructureSetAccessor structureSetAccessor = (StructureSetAccessor)structureSet;
        ArrayList structureSelectionEntries = new ArrayList(structureSet.structures());
        structureSetAccessor.setStructures(structureSelectionEntries.stream().filter(setEntry -> !this.entries.contains(setEntry.structure())).collect(Collectors.toList()));
    }

    @Override
    public Modifier.ModifierPhase getPhase() {
        return Modifier.ModifierPhase.REMOVE;
    }

    @Override
    public MapCodec<? extends Modifier> codec() {
        return CODEC;
    }
}

