/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.processor;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.NotNull;

public class BlockSwapStructureProcessor
extends StructureProcessor {
    public static final MapCodec<BlockSwapStructureProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)ResourceLocation.CODEC).fieldOf("blocks").forGetter(BlockSwapStructureProcessor::blockSwapMap)).apply((Applicative)instance, BlockSwapStructureProcessor::new));
    public static final StructureProcessorType<BlockSwapStructureProcessor> TYPE = () -> CODEC;
    private final Map<ResourceLocation, ResourceLocation> blockSwapMap;

    public BlockSwapStructureProcessor(Map<ResourceLocation, ResourceLocation> blockSwapMap) {
        this.blockSwapMap = blockSwapMap;
    }

    public Map<ResourceLocation, ResourceLocation> blockSwapMap() {
        return this.blockSwapMap;
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos blockPos, BlockPos blockPos2, StructureTemplate.StructureBlockInfo structureBlockInfo, StructureTemplate.StructureBlockInfo currentBlockInfo, StructurePlaceSettings structurePlaceSettings) {
        Block block = currentBlockInfo.state().getBlock();
        ResourceLocation blockKey = BuiltInRegistries.BLOCK.getKey((Object)block);
        if (this.blockSwapMap.containsKey(blockKey)) {
            return new StructureTemplate.StructureBlockInfo(currentBlockInfo.pos(), ((Block)BuiltInRegistries.BLOCK.get(this.blockSwapMap.get(blockKey))).withPropertiesOf(currentBlockInfo.state()), currentBlockInfo.nbt());
        }
        return currentBlockInfo;
    }

    @NotNull
    protected StructureProcessorType<?> getType() {
        return TYPE;
    }
}

