/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.gui.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrcrayfish.backpacked.client.ClientRegistry;
import com.mrcrayfish.backpacked.client.backpack.ClientBackpack;
import com.mrcrayfish.backpacked.client.gui.screen.widget.CheckBox;
import com.mrcrayfish.backpacked.client.renderer.backpack.BackpackRenderContext;
import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import com.mrcrayfish.backpacked.common.backpack.BackpackProperties;
import com.mrcrayfish.backpacked.common.backpack.ModelMeta;
import com.mrcrayfish.backpacked.core.ModDataComponents;
import com.mrcrayfish.backpacked.core.ModItems;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageBackpackCosmetics;
import com.mrcrayfish.backpacked.platform.Services;
import com.mrcrayfish.backpacked.util.ScreenUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class CustomiseBackpackScreen
extends Screen {
    public static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"textures/gui/customise_backpack.png");
    private static final Component SHOW_EFFECTS_TOOLTIP = Component.translatable((String)"backpacked.button.show_effects.tooltip");
    private static final Component SHOW_WITH_ELYTRA_TOOLTIP = Component.translatable((String)"backpacked.button.show_with_elytra.tooltip");
    private static final Component SHOW_ENCHANTMENT_GLINT = Component.translatable((String)"backpacked.button.show_enchantment_glint.tooltip");
    private static final Component LOCKED = Component.translatable((String)"backpacked.gui.locked").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD});
    private final ItemStack displayStack = new ItemStack((ItemLike)ModItems.BACKPACK.get());
    private final int windowWidth;
    private final int windowHeight;
    private int windowLeft;
    private int windowTop;
    private float windowRotationX = 35.0f;
    private float windowRotationY = 10.0f;
    private boolean windowGrabbed;
    private boolean scrollGrabbed;
    private int mouseClickedX;
    private int mouseClickedY;
    private Button resetButton;
    private Button saveButton;
    private CheckBox showEnchantmentGlintButton;
    private CheckBox showWithElytraButton;
    private CheckBox showEffectsButton;
    private BackpackProperties displayBackpack = null;
    private final List<BackpackModelEntry> models;
    private int scroll;

    public CustomiseBackpackScreen(Map<ResourceLocation, Component> progressMap) {
        super((Component)Component.translatable((String)"backpacked.title.customise_backpack"));
        this.windowWidth = 201;
        this.windowHeight = 166;
        Comparator<BackpackModelEntry> compareUnlock = Comparator.comparing(e -> !e.backpack.isUnlocked((Player)Minecraft.getInstance().player));
        Comparator<BackpackModelEntry> compareLabel = Comparator.comparing(e -> e.label.getString());
        List models = ClientRegistry.instance().getBackpacks().stream().map(backpack -> new BackpackModelEntry((ClientBackpack)backpack, progressMap)).sorted(compareUnlock.thenComparing(compareLabel)).collect(Collectors.toList());
        this.models = ImmutableList.copyOf(models);
    }

    protected void init() {
        super.init();
        if (this.displayBackpack == null) {
            this.displayBackpack = this.getCurrentBackpackProperties();
        }
        this.windowLeft = (this.width - this.windowWidth) / 2;
        this.windowTop = (this.height - this.windowHeight) / 2;
        this.resetButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"backpacked.button.reset"), onPress -> {
            this.displayBackpack = this.displayBackpack.setModel(BackpackManager.getDefaultOrFallbackCosmetic());
        }).pos(this.windowLeft + 7, this.windowTop + 114).size(71, 20).build());
        this.saveButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"backpacked.button.save"), onPress -> Network.getPlay().sendToServer((Object)new MessageBackpackCosmetics(this.displayBackpack))).pos(this.windowLeft + 7, this.windowTop + 137).size(71, 20).build());
        this.showEnchantmentGlintButton = (CheckBox)this.addRenderableWidget((GuiEventListener)new CheckBox(this.windowLeft + 133, this.windowTop + 6, CommonComponents.EMPTY, onPress -> {
            this.displayBackpack = this.displayBackpack.setShowEnchantmentGlint(!this.displayBackpack.showEnchantmentGlint());
        }));
        this.showEnchantmentGlintButton.setTooltip(Tooltip.create((Component)SHOW_ENCHANTMENT_GLINT));
        this.showWithElytraButton = (CheckBox)this.addRenderableWidget((GuiEventListener)new CheckBox(this.windowLeft + 160, this.windowTop + 6, CommonComponents.EMPTY, onPress -> {
            this.displayBackpack = this.displayBackpack.setShowWithElytra(!this.displayBackpack.showWithElytra());
        }));
        this.showWithElytraButton.setTooltip(Tooltip.create((Component)SHOW_WITH_ELYTRA_TOOLTIP));
        this.showEffectsButton = (CheckBox)this.addRenderableWidget((GuiEventListener)new CheckBox(this.windowLeft + 186, this.windowTop + 6, CommonComponents.EMPTY, onPress -> {
            this.displayBackpack = this.displayBackpack.setShowEffects(!this.displayBackpack.showEffects());
        }));
        this.showEffectsButton.setTooltip(Tooltip.create((Component)SHOW_EFFECTS_TOOLTIP));
        ItemStack backpack = Services.BACKPACK.getBackpackStack((Player)this.minecraft.player);
        if (!backpack.isEmpty()) {
            this.showEnchantmentGlintButton.setChecked(this.displayBackpack.showEnchantmentGlint());
            this.showWithElytraButton.setChecked(this.displayBackpack.showWithElytra());
            this.showEffectsButton.setChecked(this.displayBackpack.showEffects());
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.resetButton.active = !this.displayBackpack.model().equals((Object)BackpackManager.getDefaultCosmetic());
        this.saveButton.active = this.needsToSave();
    }

    private boolean needsToSave() {
        BackpackProperties properties = this.getCurrentBackpackProperties();
        return !this.displayBackpack.equals(properties);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void tick() {
        super.tick();
        this.updateButtons();
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(graphics, mouseX, mouseY, partialTick);
        graphics.blit(GUI_TEXTURE, this.windowLeft, this.windowTop, 0, 0, this.windowWidth, this.windowHeight);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        BackpackModelEntry entry;
        int startIndex;
        super.render(graphics, mouseX, mouseY, partialTick);
        graphics.drawString(this.font, this.title, this.windowLeft + 8, this.windowTop + 6, 0x404040, false);
        if (this.minecraft.player != null) {
            graphics.enableScissor(this.windowLeft + 8, this.windowTop + 18, this.windowLeft + 77, this.windowTop + 110);
            this.renderPlayer(graphics, this.windowLeft + 42, this.windowTop + this.windowHeight / 2, mouseX, mouseY, (Player)this.minecraft.player);
            graphics.disableScissor();
        }
        boolean canScroll = this.models.size() > 7;
        int scroll = (canScroll ? this.scroll : 0) + (this.scrollGrabbed ? mouseY - this.mouseClickedY : 0);
        scroll = Mth.clamp((int)scroll, (int)0, (int)123);
        graphics.blit(GUI_TEXTURE, this.windowLeft + 181, this.windowTop + 18 + scroll, 201 + (!canScroll ? 12 : 0), 0, 12, 15);
        for (int i = startIndex = (int)((double)Math.max(0, this.models.size() - 7) * Mth.clamp((double)(((double)scroll + 15.0) / 123.0), (double)0.0, (double)1.0)); i < this.models.size() && i < startIndex + 7; ++i) {
            this.drawBackpackItem(graphics, this.windowLeft + 82, this.windowTop + 17 + (i - startIndex) * 20, mouseX, mouseY, partialTick, this.models.get(i));
        }
        int hoveredIndex = this.getHoveredIndex(mouseX, mouseY);
        if (hoveredIndex != -1 && !(entry = this.models.get(hoveredIndex)).getBackpack().isUnlocked((Player)this.minecraft.player)) {
            graphics.renderTooltip(this.font, entry.getUnlockTooltip(), mouseX, mouseY);
        }
    }

    private void drawBackpackItem(GuiGraphics graphics, int x, int y, int mouseX, int mouseY, float partialTick, BackpackModelEntry entry) {
        boolean unlocked = entry.getBackpack().isUnlocked((Player)this.minecraft.player);
        boolean selected = unlocked && entry.getCosmeticId().equals((Object)this.displayBackpack.model());
        boolean hovered = unlocked && !selected && ScreenUtil.isPointInArea(mouseX, mouseY, x, y, 97, 20);
        int offset = (unlocked ? 0 : 60) + (selected ? 20 : 0) + (hovered ? 40 : 0);
        graphics.blit(GUI_TEXTURE, x, y, 0, 166 + offset, 97, 20);
        int color = selected ? 4226832 : (hovered ? 0xFFFF80 : (unlocked ? 6839882 : 5119004));
        graphics.drawString(this.font, entry.getLabel(), x + 20, y + 6, color, false);
        CustomiseBackpackScreen.drawBackpackInGui(this.minecraft, graphics, this.displayStack, entry.getBackpack(), x + 10, y + 10, partialTick);
    }

    public static void drawBackpackInGui(Minecraft mc, GuiGraphics graphics, ItemStack stack, ClientBackpack backpack, int x, int y, float partialTick) {
        PoseStack pose = graphics.pose();
        pose.pushPose();
        pose.translate((float)x, (float)y, 150.0f);
        pose.mulPose(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        pose.scale(16.0f, 16.0f, 16.0f);
        ModelMeta meta = ClientRegistry.instance().getModelMeta(backpack);
        meta.guiDisplay().ifPresent(transform -> transform.apply(false, pose));
        meta.renderer().ifPresentOrElse(renderer -> {
            BackpackRenderContext context = new BackpackRenderContext(pose, (MultiBufferSource)graphics.bufferSource(), 0xF000F0, stack, backpack, (LivingEntity)mc.player, partialTick, mc.player.tickCount, model -> {
                mc.getItemRenderer().render(stack, ItemDisplayContext.NONE, false, pose, (MultiBufferSource)graphics.bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY, model);
                graphics.flush();
            });
            pose.pushPose();
            renderer.forEach(function -> function.apply(context));
            pose.popPose();
        }, () -> {
            BakedModel model = mc.getModelManager().getModel(backpack.getBaseModel());
            mc.getItemRenderer().render(stack, ItemDisplayContext.NONE, false, pose, (MultiBufferSource)graphics.bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY, model);
            graphics.flush();
        });
        pose.popPose();
    }

    private int getHoveredIndex(int mouseX, int mouseY) {
        int displayIndex;
        int startIndex;
        int actualIndex;
        if (ScreenUtil.isPointInArea(mouseX, mouseY, this.windowLeft + 82, this.windowTop + 17, 97, 140) && (actualIndex = (startIndex = (int)((double)Math.max(0, this.models.size() - 7) * Mth.clamp((double)(((double)this.scroll + 15.0) / 123.0), (double)0.0, (double)1.0))) + (displayIndex = (mouseY - this.windowTop - 17) / 20)) >= 0 && actualIndex < this.models.size()) {
            return actualIndex;
        }
        return -1;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (ScreenUtil.isPointInArea((int)mouseX, (int)mouseY, this.windowLeft + 82, this.windowTop + 17, 97, 140)) {
            BackpackModelEntry entry;
            int hoveredIndex;
            if (button == 0 && (hoveredIndex = this.getHoveredIndex((int)mouseX, (int)mouseY)) != -1 && (entry = this.models.get(hoveredIndex)).getBackpack().isUnlocked((Player)this.minecraft.player)) {
                this.displayBackpack = this.displayBackpack.setModel(entry.getCosmeticId());
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            }
        } else if (ScreenUtil.isPointInArea((int)mouseX, (int)mouseY, this.windowLeft + 8, this.windowTop + 18, 69, 92)) {
            if (!this.windowGrabbed && button == 0) {
                this.windowGrabbed = true;
                this.mouseClickedX = (int)mouseX;
                this.mouseClickedY = (int)mouseY;
                return true;
            }
        } else if (ScreenUtil.isPointInArea((int)mouseX, (int)mouseY, this.windowLeft + 181, this.windowTop + 18 + this.scroll, 12, 15) && !this.scrollGrabbed && button == 0) {
            this.scrollGrabbed = true;
            this.mouseClickedY = (int)mouseY;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.windowGrabbed && button == 0) {
            this.windowRotationX = (float)((double)this.windowRotationX + (mouseX - (double)this.mouseClickedX));
            this.windowRotationY = (float)((double)this.windowRotationY + (mouseY - (double)this.mouseClickedY));
            this.windowGrabbed = false;
        }
        if (this.scrollGrabbed && button == 0) {
            this.scroll = (int)((double)this.scroll + (mouseY - (double)this.mouseClickedY));
            this.scroll = Mth.clamp((int)this.scroll, (int)0, (int)123);
            this.scrollGrabbed = false;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (ScreenUtil.isPointInArea((int)mouseX, (int)mouseY, this.windowLeft + 82, this.windowTop + 17, 112, 140)) {
            int startIndex = (int)((double)Math.max(0, this.models.size() - 7) * Mth.clamp((double)(((double)this.scroll + 15.0) / 123.0), (double)0.0, (double)1.0));
            int newIndex = startIndex - (int)Math.signum(deltaY);
            this.scrollToIndex(newIndex);
        }
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    private void scrollToIndex(int index) {
        this.scroll = (int)(123.0 * ((double)index / (double)Math.max(this.models.size() - 7, 1)));
        this.scroll = Mth.clamp((int)this.scroll, (int)0, (int)123);
    }

    private BackpackProperties getCurrentBackpackProperties() {
        ItemStack stack = Services.BACKPACK.getBackpackStack((Player)this.minecraft.player);
        return this.getBackpackProperties(stack);
    }

    private BackpackProperties getBackpackProperties(ItemStack stack) {
        return (BackpackProperties)stack.getOrDefault((DataComponentType)ModDataComponents.BACKPACK_PROPERTIES.get(), (Object)BackpackProperties.DEFAULT);
    }

    private void setLocalBackpackProperties(BackpackProperties properties) {
        ItemStack stack = Services.BACKPACK.getBackpackStack((Player)this.minecraft.player);
        if (!stack.isEmpty()) {
            stack.set((DataComponentType)ModDataComponents.BACKPACK_PROPERTIES.get(), (Object)properties);
        }
    }

    private void renderPlayer(GuiGraphics graphics, int x, int y, int mouseX, int mouseY, Player player) {
        Quaternionf playerRotation = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf cameraRotation = new Quaternionf();
        cameraRotation.mul((Quaternionfc)Axis.XN.rotationDegrees(this.windowRotationY + (float)(this.windowGrabbed ? mouseY - this.mouseClickedY : 0)));
        cameraRotation.mul((Quaternionfc)Axis.YP.rotationDegrees(this.windowRotationX + (float)(this.windowGrabbed ? mouseX - this.mouseClickedX : 0)));
        playerRotation.mul((Quaternionfc)cameraRotation);
        float origBodyRot = player.yBodyRot;
        float origBodyRotOld = player.yBodyRotO;
        float origYaw = player.getYRot();
        float origYawOld = player.yRotO;
        float origPitch = player.getXRot();
        float origPitchOld = player.xRotO;
        float origHeadYaw = player.yHeadRot;
        float origHeadYawOld = player.yHeadRotO;
        player.yBodyRot = 0.0f;
        player.yBodyRotO = 0.0f;
        player.setYRot(0.0f);
        player.yRotO = 0.0f;
        player.setXRot(15.0f);
        player.xRotO = 15.0f;
        player.yHeadRot = player.getYRot();
        player.yHeadRotO = player.getYRot();
        BackpackProperties originalProperties = this.getCurrentBackpackProperties();
        this.setLocalBackpackProperties(this.displayBackpack);
        float entityScale = player.getScale();
        float renderScale = 70.0f / entityScale;
        Vector3f box = new Vector3f(0.0f, player.getBbHeight() / 2.0f + entityScale * 0.0625f, 0.0f);
        InventoryScreen.renderEntityInInventory((GuiGraphics)graphics, (float)x, (float)y, (float)renderScale, (Vector3f)box, (Quaternionf)playerRotation, (Quaternionf)cameraRotation, (LivingEntity)player);
        this.setLocalBackpackProperties(originalProperties);
        player.yBodyRot = origBodyRot;
        player.yBodyRotO = origBodyRotOld;
        player.setYRot(origYaw);
        player.yRotO = origYawOld;
        player.setXRot(origPitch);
        player.xRotO = origPitchOld;
        player.yHeadRot = origHeadYaw;
        player.yHeadRotO = origHeadYawOld;
        this.setLocalBackpackProperties(originalProperties);
    }

    private static class BackpackModelEntry {
        private final ResourceLocation cosmeticId;
        private final ClientBackpack backpack;
        private final Component label;
        private final List<FormattedCharSequence> unlockTooltip;

        public BackpackModelEntry(ClientBackpack backpack, Map<ResourceLocation, Component> progressMap) {
            this.cosmeticId = backpack.getId();
            this.backpack = backpack;
            this.label = Component.translatable((String)backpack.getTranslationKey());
            MutableComponent unlockMessage = Component.translatable((String)(backpack.getTranslationKey() + ".unlock"));
            ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>(Minecraft.getInstance().font.split((FormattedText)unlockMessage, 150));
            list.add(0, Language.getInstance().getVisualOrder((FormattedText)LOCKED));
            if (progressMap.containsKey(backpack.getId())) {
                MutableComponent component = progressMap.get(backpack.getId()).plainCopy().withStyle(ChatFormatting.YELLOW);
                list.add(Language.getInstance().getVisualOrder((FormattedText)component));
            }
            this.unlockTooltip = ImmutableList.copyOf(list);
        }

        public ResourceLocation getCosmeticId() {
            return this.cosmeticId;
        }

        public Component getLabel() {
            return this.label;
        }

        public List<FormattedCharSequence> getUnlockTooltip() {
            return this.unlockTooltip;
        }

        public ClientBackpack getBackpack() {
            return this.backpack;
        }
    }
}

