/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrcrayfish.backpacked.blockentity.ShelfBlockEntity;
import com.mrcrayfish.backpacked.client.ClientRegistry;
import com.mrcrayfish.backpacked.client.backpack.ClientBackpack;
import com.mrcrayfish.backpacked.client.renderer.backpack.BackpackRenderContext;
import com.mrcrayfish.backpacked.common.backpack.BackpackProperties;
import com.mrcrayfish.backpacked.common.backpack.ModelMeta;
import com.mrcrayfish.backpacked.core.ModDataComponents;
import com.mrcrayfish.backpacked.core.ModItems;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Vector3f;

public class ShelfRenderer
implements BlockEntityRenderer<ShelfBlockEntity> {
    private final ItemRenderer itemRenderer;
    private final Supplier<BakedModel> missingModel;

    public ShelfRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.getItemRenderer();
        this.missingModel = () -> this.itemRenderer.getItemModelShaper().getModelManager().getMissingModel();
    }

    public void render(ShelfBlockEntity entity, float partialTick, PoseStack pose, MultiBufferSource buffer, int light, int overlay) {
        ItemStack stack = entity.getBackpack();
        if (stack.getItem() != ModItems.BACKPACK.get()) {
            return;
        }
        BackpackProperties properties = (BackpackProperties)stack.getOrDefault((DataComponentType)ModDataComponents.BACKPACK_PROPERTIES.get(), (Object)BackpackProperties.DEFAULT);
        ClientBackpack backpack = ClientRegistry.instance().getBackpackOrDefault(properties.model());
        if (backpack == null) {
            return;
        }
        Direction facing = entity.getDirection();
        pose.translate(0.5, 0.0, 0.5);
        pose.translate(0.0, 0.001, 0.0);
        pose.mulPose(facing.getRotation());
        pose.translate(-0.5, 0.0, -0.5);
        pose.translate(0.5, -0.375, -0.3125);
        ModelMeta meta = ClientRegistry.instance().getModelMeta(backpack);
        Vector3f offset = meta.shelfOffset();
        pose.translate((double)offset.x * 0.0625, (double)offset.z * 0.0625, (double)(-offset.y) * 0.0625);
        pose.mulPose(Axis.XP.rotationDegrees(90.0f));
        pose.scale(1.0f, -1.0f, -1.0f);
        int animationTick = Optional.ofNullable(Minecraft.getInstance().player).map(player -> player.tickCount).orElse(0);
        meta.renderer().ifPresentOrElse(renderer -> {
            pose.pushPose();
            BackpackRenderContext context = new BackpackRenderContext(pose, buffer, light, stack, backpack, null, partialTick, animationTick, model -> this.itemRenderer.render(stack, ItemDisplayContext.NONE, false, pose, buffer, light, OverlayTexture.NO_OVERLAY, model));
            renderer.forEach(function -> function.apply(context));
            pose.popPose();
        }, () -> {
            BakedModel model = this.getModel(backpack.getBaseModel());
            this.itemRenderer.render(stack, ItemDisplayContext.NONE, false, pose, buffer, light, OverlayTexture.NO_OVERLAY, model);
        });
    }

    private BakedModel getModel(ModelResourceLocation location) {
        return this.itemRenderer.getItemModelShaper().getModelManager().getModel(location);
    }
}

