/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common;

import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.item.BackpackItem;
import com.mrcrayfish.backpacked.platform.Services;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.PlayerEvents;
import com.mrcrayfish.framework.event.IPlayerEvent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundTakeItemEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class BackpackEvents {
    public static void init() {
        PlayerEvents.PICKUP_ITEM.register((IFrameworkEvent)((IPlayerEvent.PickupItem)BackpackEvents::onPickupItem));
    }

    private static boolean onPickupItem(Player player, ItemEntity entity) {
        if (((Boolean)Config.SERVER.backpack.autoEquipOnPickup.get()).booleanValue() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack stack = entity.getItem();
            if (!(stack.getItem() instanceof BackpackItem)) {
                return false;
            }
            if (Services.BACKPACK.getBackpackStack((Player)serverPlayer).isEmpty()) {
                if (Services.BACKPACK.setBackpackStack((Player)serverPlayer, stack)) {
                    ((ServerLevel)entity.level()).getChunkSource().broadcast((Entity)entity, (Packet)new ClientboundTakeItemEntityPacket(entity.getId(), serverPlayer.getId(), stack.getCount()));
                    entity.discard();
                }
                return true;
            }
        }
        return false;
    }
}

