/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common;

import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.IMovedAccess;
import com.mrcrayfish.backpacked.data.pickpocket.TraderPickpocketing;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageSyncVillagerBackpack;
import com.mrcrayfish.backpacked.platform.Services;
import com.mrcrayfish.framework.api.event.EntityEvents;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.PlayerEvents;
import com.mrcrayfish.framework.api.event.TickEvents;
import com.mrcrayfish.framework.event.IEntityEvent;
import com.mrcrayfish.framework.event.IPlayerEvent;
import com.mrcrayfish.framework.event.ITickEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class WanderingTraderEvents {
    public static final Component WANDERING_BAG_TRANSLATION = Component.translatable((String)"backpack.backpacked.wandering_bag");

    public static void init() {
        EntityEvents.JOIN_LEVEL.register((IFrameworkEvent)((IEntityEvent.JoinLevel)WanderingTraderEvents::onEntityJoinLevel));
        PlayerEvents.START_TRACKING_ENTITY.register((IFrameworkEvent)((IPlayerEvent.StartTrackingEntity)WanderingTraderEvents::onStartTracking));
        TickEvents.START_LIVING_ENTITY.register((IFrameworkEvent)((ITickEvent.StartLivingEntity)WanderingTraderEvents::onTickLivingEntity));
    }

    private static void onEntityJoinLevel(Entity entity, Level level, boolean disk) {
        if (!entity.level().isClientSide() && entity instanceof WanderingTrader) {
            WanderingTrader trader = (WanderingTrader)entity;
            if (((Boolean)Config.SERVER.wanderingTrader.enableBackpack.get()).booleanValue()) {
                TraderPickpocketing.get((Entity)trader).ifPresent(data -> {
                    if (!data.isInitialized()) {
                        boolean equipped = trader.level().random.nextInt(((Integer)Config.SERVER.wanderingTrader.spawnWithBackpackChance.get()).intValue()) == 0;
                        data.setBackpackEquipped(equipped);
                        data.setInitialized();
                    }
                });
                WanderingTraderEvents.patchTraderAiGoals(trader);
            }
        }
    }

    private static void onStartTracking(Entity entity, Player player) {
        if (entity.getType() != EntityType.WANDERING_TRADER) {
            return;
        }
        WanderingTrader trader = (WanderingTrader)entity;
        TraderPickpocketing.get((Entity)trader).ifPresent(data -> {
            if (data.isBackpackEquipped()) {
                Network.getPlay().sendToPlayer(() -> (ServerPlayer)player, (Object)new MessageSyncVillagerBackpack(entity.getId()));
            }
        });
    }

    private static void onTickLivingEntity(LivingEntity entity) {
        Level level = entity.level();
        if (level.isClientSide() || entity.getType() != EntityType.WANDERING_TRADER) {
            return;
        }
        WanderingTrader trader = (WanderingTrader)entity;
        if (trader.getUnhappyCounter() > 0) {
            trader.setUnhappyCounter(trader.getUnhappyCounter() - 1);
        }
        TraderPickpocketing.get((Entity)entity).ifPresent(data -> {
            if (!data.isBackpackEquipped()) {
                return;
            }
            Map<Player, Long> detectedPlayers = data.getDetectedPlayers();
            List<Player> newDetectedPlayers = WanderingTraderEvents.findDetectedPlayers((LivingEntity)trader);
            newDetectedPlayers.forEach(player -> detectedPlayers.put((Player)player, level.getGameTime()));
            detectedPlayers.entrySet().removeIf(WanderingTraderEvents.createForgetPlayerPredicate(trader, level));
            data.getDislikedPlayers().entrySet().removeIf(entry -> level.getGameTime() - (Long)entry.getValue() > (long)((Integer)Config.SERVER.wanderingTrader.challenge.dislikeCooldown.get()).intValue());
        });
    }

    public static boolean onInteract(Entity target, Player player) {
        Level level = target.level();
        if (!level.isClientSide() && target instanceof WanderingTrader) {
            WanderingTrader trader = (WanderingTrader)target;
            if (!((Boolean)Config.SERVER.wanderingTrader.challenge.dislikedPlayersCanTrade.get()).booleanValue() && TraderPickpocketing.get((Entity)trader).map(data -> data.isBackpackEquipped() && data.isDislikedPlayer(player)).orElse(false).booleanValue()) {
                trader.setUnhappyCounter(20);
                level.playSound(null, (Entity)trader, SoundEvents.VILLAGER_NO, SoundSource.NEUTRAL, 1.0f, 1.5f);
                return true;
            }
        }
        return false;
    }

    private static List<Player> findDetectedPlayers(LivingEntity entity) {
        return entity.level().getEntities((EntityTypeTest)EntityType.PLAYER, entity.getBoundingBox().inflate(WanderingTraderEvents.getMaxDetectionDistance()), player -> WanderingTraderEvents.isPlayerInLivingEntityVision(entity, player) && WanderingTraderEvents.isPlayerSeenByLivingEntity(entity, player, WanderingTraderEvents.getMaxDetectionDistance()) || !player.isCrouching() && WanderingTraderEvents.isPlayerMoving(player));
    }

    private static Predicate<Map.Entry<Player, Long>> createForgetPlayerPredicate(WanderingTrader trader, Level world) {
        return entry -> !((Player)entry.getKey()).isAlive() || (double)((Player)entry.getKey()).distanceTo((Entity)trader) > WanderingTraderEvents.getMaxDetectionDistance() * 2.0 || world.getGameTime() - (Long)entry.getValue() > (long)((Integer)Config.SERVER.wanderingTrader.challenge.timeToForgetPlayer.get()).intValue() && (double)((Player)entry.getKey()).distanceTo((Entity)trader) >= (Double)Config.SERVER.wanderingTrader.challenge.maxDetectionDistance.get();
    }

    private static boolean isPlayerInLivingEntityVision(LivingEntity entity, Player player) {
        if (WanderingTraderEvents.isPlayerInvisible(player)) {
            return false;
        }
        Vec3 between = entity.position().subtract(player.position());
        float angle = (float)Math.toDegrees(Mth.atan2((double)between.z, (double)between.x)) - 90.0f;
        return Mth.degreesDifferenceAbs((float)(entity.yHeadRot + 180.0f), (float)angle) <= 90.0f;
    }

    private static boolean isPlayerSeenByLivingEntity(LivingEntity entity, Player player, double distance) {
        Vec3 playerEyePos;
        if (WanderingTraderEvents.isPlayerInvisible(player)) {
            return false;
        }
        if (entity.level() != player.level() || (double)entity.distanceTo((Entity)player) > distance) {
            return false;
        }
        Vec3 livingEyePos = new Vec3(entity.getX(), entity.getEyeY(), entity.getZ());
        if (WanderingTraderEvents.performRayTrace(livingEyePos, playerEyePos = new Vec3(player.getX(), player.getEyeY(), player.getZ()), (Entity)entity).getType() == HitResult.Type.MISS) {
            return true;
        }
        Vec3 playerLegPos = new Vec3(player.getX(), player.getY() + 0.5, player.getZ());
        return WanderingTraderEvents.performRayTrace(livingEyePos, playerLegPos, (Entity)entity).getType() == HitResult.Type.MISS;
    }

    private static boolean isPlayerInvisible(Player player) {
        return player.hasEffect(MobEffects.INVISIBILITY) && player.getArmorCoverPercentage() <= 0.0f && StreamSupport.stream(player.getHandSlots().spliterator(), false).allMatch(ItemStack::isEmpty) && Services.BACKPACK.getBackpackStack(player).isEmpty();
    }

    private static BlockHitResult performRayTrace(Vec3 start, Vec3 end, Entity source) {
        return source.level().clip(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, source));
    }

    private static boolean isPlayerMoving(Player player) {
        return ((IMovedAccess)player).backpacked$Moved();
    }

    public static void openBackpack(WanderingTrader trader, ServerPlayer openingPlayer) {
        TraderPickpocketing.get((Entity)trader).ifPresent(data -> {
            if (!data.isBackpackEquipped()) {
                return;
            }
            if (data.getDetectedPlayers().containsKey(openingPlayer)) {
                trader.setUnhappyCounter(20);
                trader.getLookControl().setLookAt(openingPlayer.getEyePosition(1.0f));
                trader.level().playSound(null, (Entity)trader, SoundEvents.VILLAGER_NO, SoundSource.NEUTRAL, 1.0f, 1.5f);
                trader.level().getEntities((EntityTypeTest)EntityType.TRADER_LLAMA, trader.getBoundingBox().inflate(((Double)Config.SERVER.wanderingTrader.challenge.maxDetectionDistance.get()).doubleValue()), entity -> true).forEach(llama -> llama.setTarget((LivingEntity)openingPlayer));
                ((ServerLevel)trader.level()).sendParticles((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, trader.getX(), trader.getEyeY(), trader.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
                data.addDislikedPlayer((Player)openingPlayer, trader.level().getGameTime());
                return;
            }
            if (WanderingTraderEvents.generateBackpackLoot(trader, data)) {
                // empty if block
            }
            Services.BACKPACK.openBackpackScreen(openingPlayer, (Container)trader.getInventory(), 8, 1, false, WANDERING_BAG_TRANSLATION);
            openingPlayer.level().playSound((Player)openingPlayer, trader.getX(), trader.getY() + 1.0, trader.getZ(), (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.PLAYERS, 0.15f, 1.0f);
        });
    }

    private static boolean generateBackpackLoot(WanderingTrader trader, TraderPickpocketing data) {
        if (!data.isLootSpawned()) {
            int size = trader.getInventory().getContainerSize();
            int reserved = size / 4;
            int count = trader.level().random.nextInt(Math.max(reserved, 1)) + (size - reserved);
            List randomSlotIndexes = IntStream.range(0, size).boxed().collect(Collectors.toCollection(ArrayList::new));
            Collections.shuffle(randomSlotIndexes);
            MerchantOffers offers = trader.getOffers();
            for (int i = 0; i < size; ++i) {
                if (!((Boolean)Config.SERVER.wanderingTrader.challenge.generateEmeraldsOnly.get()).booleanValue() && i < count) {
                    MerchantOffer offer = (MerchantOffer)offers.get(trader.level().random.nextInt(offers.size()));
                    ItemStack loot = offer.getResult().copy();
                    loot.setCount(Mth.clamp((int)(loot.getCount() * (trader.level().random.nextInt(((Integer)Config.SERVER.wanderingTrader.challenge.maxLootMultiplier.get()).intValue()) + 1)), (int)0, (int)loot.getMaxStackSize()));
                    trader.getInventory().setItem(((Integer)randomSlotIndexes.get(i)).intValue(), loot);
                    continue;
                }
                ItemStack stack = new ItemStack((ItemLike)Items.EMERALD, trader.level().random.nextInt(((Integer)Config.SERVER.wanderingTrader.challenge.maxEmeraldStack.get()).intValue()) + 1);
                trader.getInventory().setItem(((Integer)randomSlotIndexes.get(i)).intValue(), stack);
            }
            data.setLootSpawned();
            return true;
        }
        return false;
    }

    private static void patchTraderAiGoals(WanderingTrader trader) {
        GoalSelector selector = Services.ENTITY.getGoalSelector((Mob)trader);
        trader.removeAllGoals(goal -> goal instanceof LookAtPlayerGoal);
        selector.addGoal(2, (Goal)new LootAtDetectedPlayerGoal(trader));
        selector.addGoal(9, (Goal)new PickpocketLookAtPlayerGoal((Mob)trader, Player.class, 3.0f, 1.0f));
    }

    private static double getMaxDetectionDistance() {
        return (Double)Config.SERVER.wanderingTrader.challenge.maxDetectionDistance.get();
    }

    private static class LootAtDetectedPlayerGoal
    extends LookAtPlayerGoal {
        private final WanderingTrader trader;

        public LootAtDetectedPlayerGoal(WanderingTrader trader) {
            super((Mob)trader, Player.class, ((Double)Config.SERVER.wanderingTrader.challenge.maxDetectionDistance.get()).floatValue() * 2.0f, 1.0f);
            this.trader = trader;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean canUse() {
            super.canUse();
            if (this.trader.getLastHurtByMob() == null && this.lookAt instanceof Player) {
                TraderPickpocketing data = TraderPickpocketing.get((Entity)this.trader).orElse(null);
                return data != null && data.isBackpackEquipped() && data.getDetectedPlayers().containsKey((Player)this.lookAt);
            }
            return false;
        }

        public boolean canContinueToUse() {
            if (this.lookAt instanceof Player && (double)this.lookAt.distanceTo((Entity)this.trader) <= (double)((Double)Config.SERVER.wanderingTrader.challenge.maxDetectionDistance.get()).floatValue() * 2.0) {
                TraderPickpocketing data = TraderPickpocketing.get((Entity)this.trader).orElse(null);
                return data != null && data.getDetectedPlayers().containsKey((Player)this.lookAt);
            }
            return false;
        }

        public void start() {
            Level level = this.trader.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                level = this.lookAt;
                if (level instanceof Player) {
                    Player player = (Player)level;
                    if (TraderPickpocketing.get((Entity)this.trader).map(data -> data.isDislikedPlayer(player)).orElse(false).booleanValue()) {
                        serverLevel.sendParticles((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, this.trader.getX(), this.trader.getEyeY(), this.trader.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
                        serverLevel.playSound(null, (Entity)this.trader, SoundEvents.VILLAGER_NO, SoundSource.NEUTRAL, 1.0f, 1.5f);
                    }
                }
            }
        }

        public void tick() {
            if (this.lookAt instanceof Player && WanderingTraderEvents.isPlayerSeenByLivingEntity((LivingEntity)this.trader, (Player)this.lookAt, (Double)Config.SERVER.wanderingTrader.challenge.maxDetectionDistance.get() * 2.0)) {
                this.trader.getLookControl().setLookAt(this.lookAt.getX(), this.lookAt.getEyeY(), this.lookAt.getZ());
            }
        }
    }

    private static class PickpocketLookAtPlayerGoal
    extends LookAtPlayerGoal {
        public PickpocketLookAtPlayerGoal(Mob entity, Class<? extends LivingEntity> entityClass, float distance, float probability) {
            super(entity, entityClass, distance, probability);
        }

        public boolean canUse() {
            if (TraderPickpocketing.get((Entity)this.mob).map(TraderPickpocketing::isBackpackEquipped).orElse(false).booleanValue()) {
                return false;
            }
            return super.canUse();
        }
    }
}

