/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.backpack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.challenge.Challenge;
import com.mrcrayfish.backpacked.common.challenge.impl.DummyChallenge;
import com.mrcrayfish.backpacked.common.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class Backpack {
    public static final StreamCodec<FriendlyByteBuf, Backpack> STREAM_CODEC = StreamCodec.of((buf, backpack) -> {
        backpack.checkSetup();
        buf.writeResourceLocation(backpack.id);
        buf.writeBoolean(backpack.challenge.isPresent());
    }, Backpack::new);
    public static final StreamCodec<FriendlyByteBuf, List<Backpack>> LIST_STREAM_CODEC = STREAM_CODEC.apply(ByteBufCodecs.collection(NonNullList::createWithCapacity));
    public static final Codec<Backpack> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Challenge.CODEC.optionalFieldOf("unlock_challenge").forGetter(backpack -> backpack.challenge)).apply((Applicative)builder, Backpack::new));
    private final Optional<Challenge> challenge;
    private ResourceLocation id;
    private String translationKey;
    private boolean setup = false;

    public Backpack(Optional<Challenge> challenge) {
        this.challenge = challenge;
    }

    public Backpack(FriendlyByteBuf buf) {
        ResourceLocation id = buf.readResourceLocation();
        this.setup(id);
        this.challenge = buf.readBoolean() ? Optional.of(DummyChallenge.INSTANCE) : Optional.empty();
    }

    public Optional<Challenge> getChallenge() {
        return this.challenge;
    }

    public ResourceLocation getId() {
        this.checkSetup();
        return this.id;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public boolean isUnlocked(Player player) {
        return UnlockManager.getTracker(player).map(tracker -> tracker.isUnlocked(this.id)).orElse(false) != false || this.challenge.isEmpty() || (Boolean)Config.SERVER.backpack.unlockAllCosmetics.get() != false;
    }

    @Nullable
    public IProgressTracker createProgressTracker(ResourceLocation backpackId) {
        return this.challenge.map(c -> c.createProgressTracker(backpackId)).orElse(null);
    }

    public void setup(ResourceLocation id) {
        if (!this.setup) {
            this.id = id;
            this.translationKey = "backpack.%s.%s".formatted(id.getNamespace(), id.getPath());
            this.setup = true;
        }
    }

    protected void checkSetup() {
        if (!this.setup) {
            throw new RuntimeException("Backpack is not setup");
        }
    }
}

