/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.data.unlock;

import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import com.mrcrayfish.backpacked.core.ModSyncedDataKeys;
import com.mrcrayfish.backpacked.data.unlock.UnlockTracker;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageSyncUnlockTracker;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.PlayerEvents;
import com.mrcrayfish.framework.api.event.TickEvents;
import com.mrcrayfish.framework.event.IPlayerEvent;
import com.mrcrayfish.framework.event.ITickEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public final class UnlockManager {
    private static UnlockManager instance;
    private final Set<ServerPlayer> testForCompletion = new HashSet<ServerPlayer>();

    public static UnlockManager instance() {
        if (instance == null) {
            instance = new UnlockManager();
        }
        return instance;
    }

    private UnlockManager() {
        PlayerEvents.LOGGED_IN.register((IFrameworkEvent)((IPlayerEvent.LoggedIn)this::onPlayerLoggedIn));
        PlayerEvents.RESPAWN.register((IFrameworkEvent)((IPlayerEvent.Respawn)this::onPlayerRespawn));
        PlayerEvents.CHANGE_DIMENSION.register((IFrameworkEvent)((IPlayerEvent.ChangeDimension)this::onPlayerChangedDimension));
        TickEvents.END_SERVER.register((IFrameworkEvent)((ITickEvent.EndServer)this::onServerTick));
        TickEvents.END_PLAYER.register((IFrameworkEvent)((ITickEvent.EndPlayer)this::onPlayerTick));
    }

    private void onPlayerTick(Player player) {
        if (player.level().isClientSide() || player.tickCount % 20 != 0) {
            return;
        }
        Level world = player.level();
        BlockPos playerPosition = player.blockPosition();
        Biome biome = (Biome)world.getBiome(playerPosition).value();
    }

    private void onPlayerLoggedIn(Player player) {
        UnlockManager.getTracker(player).ifPresent(unlockTracker -> {
            Network.getPlay().sendToPlayer(() -> (ServerPlayer)player, (Object)new MessageSyncUnlockTracker(unlockTracker.getUnlockedBackpacks()));
            UnlockManager.queuePlayerForCompletionTest((ServerPlayer)player);
        });
    }

    private void onPlayerRespawn(Player player, boolean finishedGame) {
        UnlockManager.getTracker(player).ifPresent(unlockTracker -> Network.getPlay().sendToPlayer(() -> (ServerPlayer)player, (Object)new MessageSyncUnlockTracker(unlockTracker.getUnlockedBackpacks())));
    }

    private void onPlayerChangedDimension(Player player, ResourceKey<Level> oldDimension, ResourceKey<Level> newDimension) {
        UnlockManager.getTracker(player).ifPresent(unlockTracker -> Network.getPlay().sendToPlayer(() -> (ServerPlayer)player, (Object)new MessageSyncUnlockTracker(unlockTracker.getUnlockedBackpacks())));
    }

    private void onServerTick(MinecraftServer server) {
        if (this.testForCompletion.isEmpty()) {
            return;
        }
        for (ServerPlayer player : this.testForCompletion) {
            UnlockManager.getTracker((Player)player).ifPresent(unlockTracker -> unlockTracker.getProgressTrackerMap().forEach((location, progressTracker) -> {
                if (!unlockTracker.getUnlockedBackpacks().contains(location) && progressTracker.isComplete()) {
                    BackpackManager.instance().unlockBackpack(player, (ResourceLocation)location);
                }
            }));
        }
        this.testForCompletion.clear();
    }

    public static void queuePlayerForCompletionTest(ServerPlayer player) {
        UnlockManager.instance().testForCompletion.add(player);
    }

    public static Optional<UnlockTracker> getTracker(Player player) {
        return Optional.ofNullable((UnlockTracker)((Object)ModSyncedDataKeys.UNLOCK_TRACKER.getValue((Entity)player)));
    }

    public static <T> List<T> getTrackers(Player player, Class<T> trackerClass) {
        UnlockTracker tracker = (UnlockTracker)((Object)ModSyncedDataKeys.UNLOCK_TRACKER.getValue((Entity)player));
        return tracker != null ? tracker.getProgressTrackers(trackerClass) : Collections.emptyList();
    }
}

