/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.integration;

import com.mrcrayfish.backpacked.core.ModItems;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotType;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class AccessoriesHelper {
    public static Optional<ItemStack> getStackInBackpackSlot(Player player) {
        ItemStack stack = AccessoriesHelper.getBackpackStack(player);
        if (!stack.isEmpty()) {
            return Optional.of(stack);
        }
        AccessoriesCapability accessories = AccessoriesCapability.get((LivingEntity)player);
        if (accessories != null) {
            ItemStack found = null;
            for (SlotType type : AccessoriesAPI.getValidSlotTypes((LivingEntity)player, (ItemStack)new ItemStack((ItemLike)ModItems.BACKPACK.get()))) {
                AccessoriesContainer container = accessories.getContainer(type);
                if (container == null) continue;
                for (int i = 0; i < container.getSize(); ++i) {
                    ItemStack accessoryStack = container.getAccessories().getItem(i);
                    if (accessoryStack.isEmpty()) {
                        return Optional.of(ItemStack.EMPTY);
                    }
                    if (found != null) continue;
                    found = accessoryStack;
                }
            }
            return Optional.ofNullable(found);
        }
        return Optional.empty();
    }

    public static ItemStack getBackpackStack(Player player) {
        SlotEntryReference reference;
        AccessoriesCapability accessories = AccessoriesCapability.get((LivingEntity)player);
        if (accessories != null && (reference = accessories.getFirstEquipped((Item)ModItems.BACKPACK.get())) != null) {
            return reference.stack();
        }
        return ItemStack.EMPTY;
    }

    public static void setBackpackStack(Player player, ItemStack stack) {
        AccessoriesCapability accessories = AccessoriesCapability.get((LivingEntity)player);
        if (accessories != null) {
            SlotEntryReference reference = accessories.getFirstEquipped((Item)ModItems.BACKPACK.get());
            if (reference != null) {
                reference.reference().setStack(stack);
                return;
            }
            for (SlotType type : AccessoriesAPI.getValidSlotTypes((LivingEntity)player, (ItemStack)new ItemStack((ItemLike)ModItems.BACKPACK.get()))) {
                AccessoriesContainer container = accessories.getContainer(type);
                if (container == null) continue;
                for (int i = 0; i < container.getSize(); ++i) {
                    if (!container.getAccessories().getItem(i).isEmpty()) continue;
                    container.getAccessories().setItem(i, stack.copy());
                    return;
                }
            }
        }
    }

    public static boolean isBackpackVisible(Player player) {
        AccessoriesContainer container;
        SlotEntryReference reference;
        AccessoriesCapability accessories = AccessoriesCapability.get((LivingEntity)player);
        if (accessories != null && (reference = accessories.getFirstEquipped((Item)ModItems.BACKPACK.get())) != null && (container = reference.reference().slotContainer()) != null) {
            int index = reference.reference().slot();
            return container.shouldRender(index);
        }
        return false;
    }
}

