/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.inventory;

import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.platform.Services;
import com.mrcrayfish.backpacked.util.PickpocketUtil;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;

public class BackpackInventory
extends SimpleContainer {
    private final Player player;
    private final ItemStack stack;
    private boolean save;

    public BackpackInventory(int columns, int rows, Player player, ItemStack stack) {
        super(rows * columns);
        this.player = player;
        this.stack = stack;
        this.loadBackpackContents(player);
    }

    private void loadBackpackContents(Player player) {
        ItemContainerContents contents = (ItemContainerContents)this.stack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
        contents.copyInto(this.getItems());
    }

    public ItemStack getBackpackStack() {
        return this.stack;
    }

    public boolean stillValid(Player player) {
        return this.player.isAlive() && Services.BACKPACK.getBackpackStack(this.player).equals(this.stack) && (this.player.equals((Object)player) || PickpocketUtil.canPickpocketEntity((LivingEntity)this.player, player, (Double)Config.SERVER.pickpocketing.maxReachDistance.get() + 0.5));
    }

    public void setChanged() {
        super.setChanged();
        this.save = true;
    }

    public void tick() {
        if (this.save) {
            this.saveItemsToStack();
            this.save = false;
        }
    }

    public void saveItemsToStack() {
        this.stack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)this.getItems()));
    }
}

