/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.network.play;

import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.WanderingTraderEvents;
import com.mrcrayfish.backpacked.common.backpack.Backpack;
import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import com.mrcrayfish.backpacked.common.backpack.BackpackProperties;
import com.mrcrayfish.backpacked.core.ModDataComponents;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import com.mrcrayfish.backpacked.item.BackpackItem;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageBackpackCosmetics;
import com.mrcrayfish.backpacked.network.message.MessageEntityBackpack;
import com.mrcrayfish.backpacked.network.message.MessageOpenBackpack;
import com.mrcrayfish.backpacked.network.message.MessageOpenCustomisation;
import com.mrcrayfish.backpacked.network.message.MessageRequestCustomisation;
import com.mrcrayfish.backpacked.platform.Services;
import com.mrcrayfish.backpacked.util.PickpocketUtil;
import com.mrcrayfish.framework.api.network.MessageContext;
import java.util.HashMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ServerPlayHandler {
    public static void handleCustomiseBackpack(MessageBackpackCosmetics message, MessageContext context) {
        Player player = context.getPlayer().orElse(null);
        if (player == null) {
            return;
        }
        ItemStack stack = Services.BACKPACK.getBackpackStack(player);
        if (!stack.isEmpty()) {
            BackpackProperties properties = message.properties();
            Backpack backpack = BackpackManager.instance().getBackpack(properties.model());
            if (backpack == null) {
                return;
            }
            if (!backpack.isUnlocked(player) && !((Boolean)Config.SERVER.backpack.unlockAllCosmetics.get()).booleanValue()) {
                return;
            }
            stack.set((DataComponentType)ModDataComponents.BACKPACK_PROPERTIES.get(), (Object)properties);
        }
    }

    public static void handleOpenBackpack(MessageOpenBackpack message, MessageContext context) {
        Player player = context.getPlayer().orElse(null);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BackpackItem.openBackpack(serverPlayer, serverPlayer);
        }
    }

    public static void handleEntityBackpack(MessageEntityBackpack message, MessageContext context) {
        Player player = context.getPlayer().orElse(null);
        if (player == null) {
            return;
        }
        Entity entity = player.level().getEntity(message.entityId());
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity otherEntity = (LivingEntity)entity;
        if (otherEntity instanceof ServerPlayer && !((Boolean)Config.SERVER.pickpocketing.enabled.get()).booleanValue()) {
            return;
        }
        if (!PickpocketUtil.canSeeBackpack(otherEntity, player)) {
            return;
        }
        if (otherEntity instanceof ServerPlayer) {
            ServerPlayer otherPlayer = (ServerPlayer)otherEntity;
            if (BackpackItem.openBackpack(otherPlayer, (ServerPlayer)player)) {
                otherPlayer.displayClientMessage((Component)Component.translatable((String)"message.backpacked.player_opened"), true);
                player.level().playSound(player, otherPlayer.getX(), otherPlayer.getY() + 1.0, otherPlayer.getZ(), (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.PLAYERS, 0.75f, 1.0f);
            }
        } else if (otherEntity instanceof WanderingTrader) {
            WanderingTrader trader = (WanderingTrader)otherEntity;
            WanderingTraderEvents.openBackpack(trader, (ServerPlayer)player);
        }
    }

    public static void handleRequestCustomisation(MessageRequestCustomisation message, MessageContext context) {
        Player player = context.getPlayer().orElse(null);
        if (player == null) {
            return;
        }
        if (((Boolean)Config.SERVER.backpack.disableCustomisation.get()).booleanValue()) {
            return;
        }
        if (Services.BACKPACK.getBackpackStack(player).isEmpty()) {
            return;
        }
        UnlockManager.getTracker(player).ifPresent(unlockTracker -> {
            HashMap<ResourceLocation, Component> map = new HashMap<ResourceLocation, Component>();
            for (Backpack backpack : BackpackManager.instance().getBackpacks()) {
                if (unlockTracker.isUnlocked(backpack.getId())) continue;
                unlockTracker.getProgressTracker(backpack.getId()).ifPresent(progressTracker -> map.put(backpack.getId(), progressTracker.getDisplayComponent()));
            }
            Network.getPlay().sendToPlayer(() -> (ServerPlayer)player, (Object)new MessageOpenCustomisation(map));
        });
    }
}

