/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.config;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import me.pepperbell.continuity.client.config.ContinuityConfig;
import me.pepperbell.continuity.client.config.Option;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ContinuityConfigScreen
extends Screen {
    private final Screen parent;
    private final ContinuityConfig config;
    private List<Value<?>> values;

    public ContinuityConfigScreen(Screen parent, ContinuityConfig config) {
        super((Component)Component.translatable((String)ContinuityConfigScreen.getTranslationKey("title")));
        this.parent = parent;
        this.config = config;
    }

    protected void init() {
        Value<Boolean> connectedTextures = Value.of(this.config.connectedTextures, Value.Flag.RELOAD_WORLD_RENDERER);
        Value<Boolean> emissiveTextures = Value.of(this.config.emissiveTextures, Value.Flag.RELOAD_WORLD_RENDERER);
        Value<Boolean> customBlockLayers = Value.of(this.config.customBlockLayers, Value.Flag.RELOAD_WORLD_RENDERER);
        this.values = List.of(connectedTextures, emissiveTextures, customBlockLayers);
        this.addRenderableWidget((GuiEventListener)this.startBooleanValueButton(connectedTextures).bounds(this.width / 2 - 100 - 110, this.height / 2 - 10 - 12, 200, 20).build());
        this.addRenderableWidget((GuiEventListener)this.startBooleanValueButton(emissiveTextures).bounds(this.width / 2 - 100 + 110, this.height / 2 - 10 - 12, 200, 20).build());
        this.addRenderableWidget((GuiEventListener)this.startBooleanValueButton(customBlockLayers).bounds(this.width / 2 - 100 - 110, this.height / 2 - 10 + 12, 200, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            this.saveValues();
            this.onClose();
        }).bounds(this.width / 2 - 75 - 79, this.height - 40, 150, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.onClose()).bounds(this.width / 2 - 75 + 79, this.height - 40, 150, 20).build());
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        context.drawCenteredString(this.font, this.title, this.width / 2, 30, 0xFFFFFF);
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    private void saveValues() {
        EnumSet<Value.Flag> flags = EnumSet.noneOf(Value.Flag.class);
        for (Value<?> value : this.values) {
            if (!value.isChanged()) continue;
            value.saveToOption();
            flags.addAll(value.getFlags());
        }
        this.config.save();
        for (Value.Flag flag : flags) {
            flag.onSave();
        }
    }

    private static String getTranslationKey(String optionKey) {
        return "options.continuity." + optionKey;
    }

    private static String getTooltipKey(String translationKey) {
        return translationKey + ".tooltip";
    }

    private Button.Builder startBooleanValueButton(Value<Boolean> value) {
        String translationKey = ContinuityConfigScreen.getTranslationKey(value.getOption().getKey());
        MutableComponent text = Component.translatable((String)translationKey);
        MutableComponent tooltipText = Component.translatable((String)ContinuityConfigScreen.getTooltipKey(translationKey));
        return Button.builder((Component)CommonComponents.optionNameValue((Component)text, (Component)CommonComponents.optionStatus((boolean)value.get())), arg_0 -> ContinuityConfigScreen.lambda$startBooleanValueButton$3(value, (Component)text, arg_0)).tooltip(Tooltip.create((Component)tooltipText));
    }

    private static /* synthetic */ void lambda$startBooleanValueButton$3(Value value, Component text, Button button) {
        boolean newValue = (Boolean)value.get() == false;
        value.set(newValue);
        Component valueText = CommonComponents.optionStatus((boolean)newValue);
        if (value.isChanged()) {
            valueText = valueText.copy().withStyle(style -> style.withBold(Boolean.valueOf(true)));
        }
        button.setMessage((Component)CommonComponents.optionNameValue((Component)text, (Component)valueText));
    }

    private static class Value<T> {
        private final Option<T> option;
        private final Set<Flag> flags;
        private final T originalValue;
        private T value;

        public Value(Option<T> option, Set<Flag> flags) {
            this.option = option;
            this.flags = flags;
            this.originalValue = this.option.get();
            this.value = this.originalValue;
        }

        public static <T> Value<T> of(Option<T> option, Flag ... flags) {
            EnumSet<Flag> flagSet = EnumSet.noneOf(Flag.class);
            Collections.addAll(flagSet, flags);
            return new Value<T>(option, flagSet);
        }

        public Option<T> getOption() {
            return this.option;
        }

        public Set<Flag> getFlags() {
            return this.flags;
        }

        public T get() {
            return this.value;
        }

        public void set(T value) {
            this.value = value;
        }

        public boolean isChanged() {
            return !this.value.equals(this.originalValue);
        }

        public void saveToOption() {
            this.option.set(this.value);
        }

        public static enum Flag {
            RELOAD_WORLD_RENDERER{

                @Override
                public void onSave() {
                    Minecraft.getInstance().levelRenderer.allChanged();
                }
            };


            public abstract void onSave();
        }
    }
}

