/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.event.events.client.ClientCommandRegistrationEvent;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import org.orecruncher.dsurround.commands.AbstractClientCommand;
import org.orecruncher.dsurround.commands.handlers.BiomeCommandHandler;

class BiomeCommand
extends AbstractClientCommand {
    private static final String COMMAND = "dsbiome";
    private static final String BIOME_PARAMETER = "biome";
    private static final String SCRIPT_PARAMETER = "script";

    BiomeCommand() {
    }

    @Override
    public void register(CommandDispatcher<ClientCommandRegistrationEvent.ClientCommandSourceStack> dispatcher, CommandBuildContext registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandRegistrationEvent.literal((String)COMMAND).then(ClientCommandRegistrationEvent.argument((String)BIOME_PARAMETER, (ArgumentType)ResourceArgument.resource((CommandBuildContext)registryAccess, (ResourceKey)Registries.BIOME)).then(ClientCommandRegistrationEvent.argument((String)SCRIPT_PARAMETER, (ArgumentType)MessageArgument.message()).executes(this::execute))));
    }

    public int execute(CommandContext<ClientCommandRegistrationEvent.ClientCommandSourceStack> ctx) throws CommandSyntaxException {
        Holder.Reference reference = (Holder.Reference)ctx.getArgument(BIOME_PARAMETER, Holder.Reference.class);
        ResourceKey registryKey = reference.key();
        if (!registryKey.isFor(Registries.BIOME)) {
            throw ResourceArgument.ERROR_INVALID_RESOURCE_TYPE.create((Object)registryKey.location(), (Object)registryKey.registry(), (Object)Registries.BIOME.registry());
        }
        MessageArgument.Message script = (MessageArgument.Message)ctx.getArgument(SCRIPT_PARAMETER, MessageArgument.Message.class);
        return this.execute(ctx, () -> BiomeCommandHandler.execute(registryKey.location(), script.text()));
    }
}

