/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.commands.handlers;

import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import org.orecruncher.dsurround.config.libraries.IBiomeLibrary;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.lib.scripting.Script;

public class BiomeCommandHandler {
    public static Component execute(ResourceLocation biomeIdentifier, String script) {
        return (Component)GameUtils.getRegistryManager().map(rm -> {
            Optional<Biome> biome = rm.registry(Registries.BIOME).map(r -> (Biome)r.get(biomeIdentifier));
            if (biome.isEmpty()) {
                return Component.translatable((String)"dsurround.command.dsbiome.failure.unknown_biome", (Object[])new Object[]{biomeIdentifier.toString()});
            }
            Object result = ContainerManager.resolve(IBiomeLibrary.class).eval(biome.get(), new Script(script));
            return Component.literal((String)result.toString());
        }).orElse(Component.literal((String)"Unable to locate registry manager"));
    }
}

