/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config;

import com.google.common.base.MoreObjects;
import net.minecraft.util.random.Weight;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.lib.WeightTable;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.lib.scripting.Script;
import org.orecruncher.dsurround.runtime.IConditionEvaluator;
import org.orecruncher.dsurround.sound.ISoundFactory;

public class AcousticEntry
implements WeightTable.IItem<ISoundFactory> {
    private static final IConditionEvaluator CONDITION_EVALUATOR = ContainerManager.resolve(IConditionEvaluator.class);
    private static final Weight DEFAULT_WEIGHT = Weight.of((int)10);
    private final Weight weight;
    private final ISoundFactory acoustic;
    private final Script conditions;

    public AcousticEntry(ISoundFactory acoustic, @Nullable Script condition) {
        this(acoustic, condition, DEFAULT_WEIGHT);
    }

    public AcousticEntry(ISoundFactory acoustic, @Nullable Script condition, Weight weight) {
        this.acoustic = acoustic;
        this.weight = weight;
        this.conditions = condition != null ? condition : Script.TRUE;
    }

    @NotNull
    public Weight getWeight() {
        return this.weight;
    }

    @Override
    public ISoundFactory data() {
        return this.getAcoustic();
    }

    public ISoundFactory getAcoustic() {
        return this.acoustic;
    }

    public Script getConditions() {
        return this.conditions;
    }

    public boolean matches() {
        return this.conditions == Script.TRUE || CONDITION_EVALUATOR.check(this.conditions);
    }

    protected Script getConditionsForLogging() {
        return this.getConditions();
    }

    public int hashCode() {
        return this.conditions.hashCode() * 31 + this.acoustic.getLocation().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof AcousticEntry) {
            AcousticEntry ae = (AcousticEntry)o;
            return ae.conditions.equals(this.conditions) && ae.acoustic.getLocation().equals((Object)this.acoustic.getLocation());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.getWeight()).addValue((Object)this.getAcoustic().toString()).addValue((Object)this.getConditionsForLogging()).toString();
    }
}

