/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config;

import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.util.random.SimpleWeightedRandomList;
import org.orecruncher.dsurround.config.AcousticEntry;
import org.orecruncher.dsurround.lib.WeightTable;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.random.Randomizer;
import org.orecruncher.dsurround.sound.ISoundFactory;

public class AcousticEntryCollection
extends ObjectArray<AcousticEntry> {
    public static final AcousticEntryCollection EMPTY = new AcousticEntryCollection(){

        @Override
        public boolean add(AcousticEntry entry) {
            throw new RuntimeException("Cannot add AcousticEntry to EMPTY collection");
        }

        @Override
        public Stream<AcousticEntry> findMatches() {
            return Stream.empty();
        }

        @Override
        public Optional<ISoundFactory> makeSelection() {
            return Optional.empty();
        }

        @Override
        public SimpleWeightedRandomList<ISoundFactory> matchesAsWeightedList() {
            return SimpleWeightedRandomList.empty();
        }
    };

    @Override
    public boolean add(AcousticEntry entry) {
        if (this.contains(entry)) {
            return false;
        }
        return super.add(entry);
    }

    public Stream<AcousticEntry> findMatches() {
        return this.stream().filter(AcousticEntry::matches);
    }

    public SimpleWeightedRandomList<ISoundFactory> matchesAsWeightedList() {
        SimpleWeightedRandomList.Builder builder = new SimpleWeightedRandomList.Builder();
        this.findMatches().forEach(m -> builder.add((Object)m.getAcoustic(), m.getWeight().asInt()));
        return builder.build();
    }

    public Optional<ISoundFactory> makeSelection() {
        return WeightTable.makeSelection(this.findMatches(), Randomizer.current());
    }

    static {
        EMPTY.trim();
    }
}

