/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.orecruncher.dsurround.Configuration;
import org.orecruncher.dsurround.effects.IBlockEffectProducer;
import org.orecruncher.dsurround.effects.blocks.producers.BlockParticleEffectProducer;
import org.orecruncher.dsurround.effects.blocks.producers.FlameJetProducer;
import org.orecruncher.dsurround.effects.blocks.producers.UnderwaterBubbleProducer;
import org.orecruncher.dsurround.effects.particles.FireflyParticle;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.lib.scripting.Script;

public enum BlockEffectType {
    UNKNOWN("unknown", (chance, condition) -> null),
    FLAME_JET("fire_jet", FlameJetProducer::new),
    BUBBLE_COLUMN("bubble_column", UnderwaterBubbleProducer::new),
    FIREFLY("firefly", (chance, conditions) -> new BlockParticleEffectProducer((Script)chance, (Script)conditions, (world, state, pos, rand) -> new FireflyParticle(world, (double)pos.getX() + 0.0, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5)));

    private static final Map<String, BlockEffectType> BY_NAME;
    public static final Codec<BlockEffectType> CODEC;
    private final String name;
    private final BiFunction<Script, Script, IBlockEffectProducer> producer;
    private BooleanSupplier enabled;

    private BlockEffectType(String name, BiFunction<Script, Script, IBlockEffectProducer> producerFactory) {
        this.name = name;
        this.producer = producerFactory;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled.getAsBoolean();
    }

    public Optional<IBlockEffectProducer> createInstance(Script chance, Script conditions) {
        if (this.isEnabled()) {
            return Optional.ofNullable(this.producer.apply(chance, conditions));
        }
        return Optional.empty();
    }

    private void setConfigProvider(BooleanSupplier supplier) {
        this.enabled = supplier;
    }

    public static BlockEffectType byName(String name) {
        return BY_NAME.get(name);
    }

    static {
        BY_NAME = Arrays.stream(BlockEffectType.values()).collect(Collectors.toMap(BlockEffectType::getName, category -> category));
        CODEC = Codec.STRING.comapFlatMap(DataResult.partialGet(BY_NAME::get, () -> "unknown block effect type"), d -> d.name);
        Configuration.BlockEffects config = ContainerManager.resolve(Configuration.BlockEffects.class);
        UNKNOWN.setConfigProvider(() -> false);
        FLAME_JET.setConfigProvider(() -> config.flameJetEnabled);
        BUBBLE_COLUMN.setConfigProvider(() -> config.bubbleColumnEnabled);
        FIREFLY.setConfigProvider(() -> config.firefliesEnabled);
    }
}

