/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.orecruncher.dsurround.config.data.DimensionConfigRule;
import org.orecruncher.dsurround.lib.world.WorldUtils;

public class DimensionInfo {
    public static final DimensionInfo NONE = new DimensionInfo();
    private static final int SPACE_HEIGHT_OFFSET = 32;
    protected final boolean isFlatWorld;
    protected ResourceLocation name;
    protected int seaLevel;
    protected int skyHeight;
    protected int cloudHeight;
    protected int spaceHeight;
    protected boolean alwaysOutside = false;
    protected boolean playBiomeSounds = true;
    protected boolean compassWobble = false;

    DimensionInfo() {
        this.name = ResourceLocation.fromNamespaceAndPath((String)"dsurround", (String)"no_dimension");
        this.isFlatWorld = false;
    }

    public DimensionInfo(Level world) {
        this.name = world.dimension().location();
        this.seaLevel = world.getSeaLevel();
        this.cloudHeight = this.skyHeight = world.getHeight();
        this.spaceHeight = this.skyHeight + 32;
        this.isFlatWorld = WorldUtils.isSuperFlat(world);
        if (this.isFlatWorld) {
            this.seaLevel = 0;
        }
        this.compassWobble = !world.dimensionType().natural();
    }

    public void update(DimensionConfigRule config) {
        if (this.name.equals((Object)config.dimensionId())) {
            config.seaLevel().ifPresent(v -> {
                this.seaLevel = v;
            });
            config.skyHeight().ifPresent(v -> {
                this.skyHeight = v;
            });
            config.alwaysOutside().ifPresent(v -> {
                this.alwaysOutside = v;
            });
            config.playBiomeSounds().ifPresent(v -> {
                this.playBiomeSounds = v;
            });
            config.cloudHeight().ifPresentOrElse(v -> {
                this.cloudHeight = v;
            }, () -> {
                this.cloudHeight = this.skyHeight / 2;
            });
            config.compassWobble().ifPresent(v -> {
                this.compassWobble = v;
            });
            this.spaceHeight = this.skyHeight + 32;
        }
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public int getSeaLevel() {
        return this.seaLevel;
    }

    public int getSkyHeight() {
        return this.skyHeight;
    }

    public int getCloudHeight() {
        return this.cloudHeight;
    }

    public int getSpaceHeight() {
        return this.spaceHeight;
    }

    public boolean playBiomeSounds() {
        return this.playBiomeSounds;
    }

    public boolean alwaysOutside() {
        return this.alwaysOutside;
    }

    public boolean isFlatWorld() {
        return this.isFlatWorld;
    }

    public boolean getCompassWobble() {
        return this.compassWobble;
    }
}

