/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.lang.invoke.LambdaMetafactory;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import org.orecruncher.dsurround.config.libraries.ITagLibrary;
import org.orecruncher.dsurround.lib.IMatcher;
import org.orecruncher.dsurround.lib.IdentityUtils;
import org.orecruncher.dsurround.lib.di.ContainerManager;

public abstract class EntityTypeMatcher
implements IMatcher<Entity> {
    public static final Codec<IMatcher<Entity>> CODEC = Codec.STRING.comapFlatMap(EntityTypeMatcher::manifest, (Function<IMatcher, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lorg/orecruncher/dsurround/lib/IMatcher;)Ljava/lang/String;)()).stable();

    private static DataResult<IMatcher<Entity>> manifest(String entityTypeId) {
        try {
            if (entityTypeId.startsWith("#")) {
                ResourceLocation id = IdentityUtils.resolveIdentifier(entityTypeId);
                TagKey tagKey = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)id);
                return DataResult.success((Object)new MatchOnEntityTag(tagKey));
            }
            if (entityTypeId.contains(":")) {
                Optional type = EntityType.byString((String)entityTypeId);
                return type.map(entityType -> DataResult.success((Object)new MatchOnEntityType((EntityType<?>)entityType))).orElseGet(() -> DataResult.error(() -> String.format("Unknown entity type id %s", entityTypeId)));
            }
            return DataResult.error(() -> String.format("Unknown entity class(s) %s", entityTypeId));
        }
        catch (Throwable t) {
            return DataResult.error(t::getMessage);
        }
    }

    @Override
    public abstract boolean match(Entity var1);

    private static class MatchOnEntityTag
    extends EntityTypeMatcher {
        private static final ITagLibrary TAG_LIBRARY = ContainerManager.resolve(ITagLibrary.class);
        private final TagKey<EntityType<?>> tagKey;

        public MatchOnEntityTag(TagKey<EntityType<?>> tagKey) {
            this.tagKey = tagKey;
        }

        @Override
        public boolean match(Entity entity) {
            return TAG_LIBRARY.is(this.tagKey, entity.getType());
        }
    }

    private static class MatchOnEntityType
    extends EntityTypeMatcher {
        private final EntityType<?> type;

        public MatchOnEntityType(EntityType<?> type) {
            this.type = type;
        }

        @Override
        public boolean match(Entity entity) {
            return this.type == entity.getType();
        }
    }
}

