/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.lang.invoke.LambdaMetafactory;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import org.orecruncher.dsurround.config.libraries.ITagLibrary;
import org.orecruncher.dsurround.lib.IMatcher;
import org.orecruncher.dsurround.lib.IdentityUtils;
import org.orecruncher.dsurround.lib.di.ContainerManager;

public abstract class ItemTypeMatcher
implements IMatcher<Item> {
    public static final Codec<IMatcher<Item>> CODEC = Codec.STRING.comapFlatMap(ItemTypeMatcher::manifest, (Function<IMatcher, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lorg/orecruncher/dsurround/lib/IMatcher;)Ljava/lang/String;)()).stable();

    private static DataResult<IMatcher<Item>> manifest(String itemId) {
        try {
            ResourceLocation id = IdentityUtils.resolveIdentifier(itemId);
            if (itemId.startsWith("#")) {
                TagKey tagKey = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)id);
                return DataResult.success((Object)new MatchOnItemTag((TagKey<Item>)tagKey));
            }
            if (itemId.contains(":")) {
                Item item = (Item)BuiltInRegistries.ITEM.get(id);
                return DataResult.success((Object)new MatchOnItem(item));
            }
            return DataResult.error(() -> String.format("Unknown item class(s) %s", itemId));
        }
        catch (Throwable t) {
            return DataResult.error(t::getMessage);
        }
    }

    @Override
    public abstract boolean match(Item var1);

    private static class MatchOnItemTag
    extends ItemTypeMatcher {
        private static final ITagLibrary TAG_LIBRARY = ContainerManager.resolve(ITagLibrary.class);
        private final TagKey<Item> tagKey;

        public MatchOnItemTag(TagKey<Item> tagKey) {
            this.tagKey = tagKey;
        }

        @Override
        public boolean match(Item item) {
            return TAG_LIBRARY.is(this.tagKey, item);
        }
    }

    private static class MatchOnItem
    extends ItemTypeMatcher {
        private final Item item;

        MatchOnItem(Item item) {
            this.item = item;
        }

        @Override
        public boolean match(Item item) {
            return this.item == item;
        }
    }
}

