/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum SoundEventType {
    LOOP("loop"),
    MOOD("mood"),
    ADDITION("addition"),
    MUSIC("music");

    private static final Map<String, SoundEventType> BY_NAME;
    public static final Codec<SoundEventType> CODEC;
    private final String name;

    private SoundEventType(String name) {
        this.name = name;
    }

    public static SoundEventType byName(String name) {
        return BY_NAME.get(name);
    }

    public String getName() {
        return this.name;
    }

    static {
        BY_NAME = Arrays.stream(SoundEventType.values()).collect(Collectors.toMap(SoundEventType::getName, category -> category));
        CODEC = Codec.STRING.comapFlatMap(DataResult.partialGet(BY_NAME::get, () -> "unknown sound event type"), d -> d.name);
    }
}

