/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config;

import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.config.data.SoundMappingConfigRule;
import org.orecruncher.dsurround.lib.IMatcher;
import org.orecruncher.dsurround.lib.collections.ObjectArray;

public record SoundMapping(ResourceLocation soundEvent, ObjectArray<Mapping> rules) {
    public static SoundMapping of(SoundMappingConfigRule rule) {
        ObjectArray<Mapping> mappings = new ObjectArray<Mapping>(rule.rules().size());
        rule.rules().forEach(r -> mappings.add(Mapping.of(r)));
        return new SoundMapping(rule.soundEvent(), mappings);
    }

    public boolean isBlockStateNeeded() {
        return !this.rules.isEmpty() && !this.rules.getFirst().isDefaultRule();
    }

    public Optional<ResourceLocation> findMatch(@Nullable BlockState state) {
        Mapping rule;
        Optional<ResourceLocation> factory = Optional.empty();
        Iterator<Mapping> iterator = this.rules.iterator();
        while (iterator.hasNext() && !(factory = (rule = iterator.next()).findMatch(state)).isPresent()) {
        }
        return factory;
    }

    public void merge(SoundMappingConfigRule mapping) {
        if (!this.soundEvent.equals((Object)mapping.soundEvent())) {
            throw new RuntimeException("Unable to merge sound mapping rule - factories do not match");
        }
        for (SoundMappingConfigRule.MappingRule rule : mapping.rules()) {
            Mapping mapped = Mapping.of(rule);
            Optional<Mapping> existingRule = this.rules.stream().filter(r -> r.factory().equals((Object)rule.factory())).findFirst();
            if (existingRule.isPresent()) {
                if (existingRule.get().isDefaultRule()) {
                    this.insertBeforeDefaultRule(mapped);
                    continue;
                }
                existingRule.get().merge(mapped);
                continue;
            }
            Mapping last = this.rules.getLast();
            if (last.isDefaultRule()) {
                this.insertBeforeDefaultRule(mapped);
                continue;
            }
            this.rules.add(mapped);
        }
    }

    private void insertBeforeDefaultRule(Mapping mapping) {
        Mapping last = this.rules.getLast();
        if (!last.isDefaultRule()) {
            throw new RuntimeException("Last rule in sound mapping configuration is not default");
        }
        this.rules.remove(last);
        this.rules.add(mapping);
        this.rules.add(last);
    }

    public record Mapping(ObjectArray<IMatcher<BlockState>> blocks, ResourceLocation factory) {
        public static Mapping of(SoundMappingConfigRule.MappingRule mappingRule) {
            ObjectArray<IMatcher<BlockState>> blocks = new ObjectArray<IMatcher<BlockState>>(mappingRule.blocks().size());
            blocks.addAll((Collection<IMatcher<BlockState>>)mappingRule.blocks());
            return new Mapping(blocks, mappingRule.factory());
        }

        public Optional<ResourceLocation> findMatch(@Nullable BlockState state) {
            if (this.isDefaultRule()) {
                return Optional.of(this.factory);
            }
            if (state == null) {
                return Optional.empty();
            }
            for (IMatcher<BlockState> rule : this.blocks) {
                if (!rule.match(state)) continue;
                return Optional.of(this.factory);
            }
            return Optional.empty();
        }

        public boolean isDefaultRule() {
            return this.blocks.isEmpty();
        }

        public void merge(Mapping rule) {
            if (!this.factory.equals((Object)rule.factory())) {
                throw new RuntimeException("Unable to add mapping rule - factories do not match");
            }
            this.blocks.addAll((Collection<IMatcher<BlockState>>)rule.blocks());
        }
    }
}

