/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config.biome.biometraits;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import org.orecruncher.dsurround.config.BiomeTrait;
import org.orecruncher.dsurround.config.biome.biometraits.BiomeMysticalAnalyzer;
import org.orecruncher.dsurround.config.biome.biometraits.BiomeTagAnalyzer;
import org.orecruncher.dsurround.config.biome.biometraits.IBiomeTraitAnalyzer;
import org.orecruncher.dsurround.lib.collections.ObjectArray;

public final class BiomeTraits {
    private static final ObjectArray<IBiomeTraitAnalyzer> traitAnalyzer = new ObjectArray(4);
    private final Set<BiomeTrait> traits;
    private boolean updatedByMerge;

    BiomeTraits(Collection<BiomeTrait> traits) {
        this.traits = new HashSet<BiomeTrait>(traits);
    }

    public static BiomeTraits createFrom(ResourceLocation id, Biome biome) {
        List<BiomeTrait> traits = traitAnalyzer.stream().map(analyzer -> analyzer.evaluate(id, biome)).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        return new BiomeTraits(traits);
    }

    public static BiomeTraits from(BiomeTrait ... traits) {
        return new BiomeTraits(List.of(traits));
    }

    public void mergeTraits(Collection<BiomeTrait> traits) {
        int count = this.traits.size();
        this.traits.addAll(traits);
        this.updatedByMerge = this.updatedByMerge || count != this.traits.size();
    }

    public boolean contains(String trait) {
        return this.contains(BiomeTrait.of(trait));
    }

    public boolean contains(BiomeTrait trait) {
        return this.traits.contains((Object)trait);
    }

    public void forEach(Consumer<BiomeTrait> consumer) {
        for (BiomeTrait t : this.traits) {
            consumer.accept(t);
        }
    }

    public String toString() {
        String temp = this.traits.stream().map(BiomeTrait::getName).collect(Collectors.joining(", "));
        String fmt = this.updatedByMerge ? "*[%s]" : "[%s]";
        return fmt.formatted(temp);
    }

    static {
        traitAnalyzer.add(new BiomeTagAnalyzer());
        traitAnalyzer.add(new BiomeMysticalAnalyzer());
    }
}

