/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config.block;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.config.AcousticEntry;
import org.orecruncher.dsurround.config.AcousticEntryCollection;
import org.orecruncher.dsurround.config.data.AcousticConfig;
import org.orecruncher.dsurround.config.data.BlockConfigRule;
import org.orecruncher.dsurround.config.data.BlockEffectConfigRule;
import org.orecruncher.dsurround.config.libraries.ISoundLibrary;
import org.orecruncher.dsurround.config.libraries.ITagLibrary;
import org.orecruncher.dsurround.effects.IBlockEffectProducer;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.di.ContainerManager;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.logging.ModLog;
import org.orecruncher.dsurround.lib.random.IRandomizer;
import org.orecruncher.dsurround.lib.scripting.Script;
import org.orecruncher.dsurround.runtime.IConditionEvaluator;
import org.orecruncher.dsurround.sound.ISoundFactory;
import org.orecruncher.dsurround.tags.OcclusionTags;
import org.orecruncher.dsurround.tags.ReflectanceTags;

public class BlockInfo {
    private static final IModLog LOGGER = ModLog.createChild(ContainerManager.resolve(IModLog.class), "BlockInfo");
    private static final IConditionEvaluator CONDITION_EVALUATOR = ContainerManager.resolve(IConditionEvaluator.class);
    private static final ISoundLibrary SOUND_LIBRARY = ContainerManager.resolve(ISoundLibrary.class);
    private static final ITagLibrary TAG_LIBRARY = ContainerManager.resolve(ITagLibrary.class);
    protected final int version;
    @Nullable
    protected final ResourceLocation stepSound;
    protected AcousticEntryCollection sounds = new AcousticEntryCollection();
    protected Collection<IBlockEffectProducer> blockEffects = new ObjectArray<IBlockEffectProducer>();
    protected Script soundChance = new Script("0.01");
    protected float soundReflectivity = 0.35f;
    protected float soundOcclusion = 0.5f;

    public BlockInfo(int version) {
        this.version = version;
        this.stepSound = null;
    }

    public BlockInfo(int version, BlockState state) {
        this.version = version;
        this.soundOcclusion = BlockInfo.getSoundOcclusionSetting(state);
        this.soundReflectivity = BlockInfo.getSoundReflectionSetting(state);
        this.stepSound = state.getSoundType().getStepSound().getLocation();
    }

    public boolean isDefault() {
        return this.sounds == null && this.blockEffects == null && this.soundReflectivity == 0.35f && (this.soundOcclusion == 0.5f || this.soundOcclusion == 0.15f);
    }

    public int getVersion() {
        return this.version;
    }

    public float getSoundReflectivity() {
        return this.soundReflectivity;
    }

    public float getSoundOcclusion() {
        return this.soundOcclusion;
    }

    private void addToBlockEffects(IBlockEffectProducer effect) {
        this.blockEffects.add(effect);
    }

    public void update(BlockConfigRule config) {
        if (config.clearSounds().booleanValue()) {
            this.clearSounds();
        }
        config.soundChance().ifPresent(v -> {
            this.soundChance = v;
        });
        for (AcousticConfig sr : config.acoustics()) {
            ISoundFactory factory = SOUND_LIBRARY.getSoundFactoryOrDefault(sr.factory());
            AcousticEntry acousticEntry = new AcousticEntry(factory, sr.conditions(), sr.weight());
            if (this.sounds.add(acousticEntry)) continue;
            LOGGER.warn("[BlockInfo] Duplicate acoustic entry: %s", sr.toString());
        }
        for (BlockEffectConfigRule e : config.effects()) {
            Optional<IBlockEffectProducer> effect = e.effect().createInstance(e.spawnChance(), e.conditions());
            effect.ifPresent(this::addToBlockEffects);
        }
    }

    private void clearSounds() {
        if (this.sounds != null) {
            this.sounds.clear();
        }
    }

    public boolean hasSoundsOrEffects() {
        return this.sounds != null || this.blockEffects != null;
    }

    public Optional<ISoundFactory> getSoundToPlay(IRandomizer random) {
        Object chance;
        if (this.sounds != null && (chance = CONDITION_EVALUATOR.eval(this.soundChance)) instanceof Double) {
            Double c = (Double)chance;
            if (random.nextDouble() < c) {
                return this.sounds.makeSelection();
            }
        }
        return Optional.empty();
    }

    public Collection<IBlockEffectProducer> getEffectProducers() {
        return this.blockEffects;
    }

    public void trim() {
        if (this.sounds.isEmpty()) {
            this.sounds = AcousticEntryCollection.EMPTY;
        }
        if (this.blockEffects.isEmpty()) {
            this.blockEffects = ImmutableList.of();
        }
    }

    private static float getSoundReflectionSetting(BlockState state) {
        if (TAG_LIBRARY.is(ReflectanceTags.NONE, state)) {
            return 0.0f;
        }
        if (TAG_LIBRARY.is(ReflectanceTags.VERY_LOW, state)) {
            return 0.15f;
        }
        if (TAG_LIBRARY.is(ReflectanceTags.LOW, state)) {
            return 0.35f;
        }
        if (TAG_LIBRARY.is(ReflectanceTags.MEDIUM, state)) {
            return 0.5f;
        }
        if (TAG_LIBRARY.is(ReflectanceTags.HIGH, state)) {
            return 0.65f;
        }
        if (TAG_LIBRARY.is(ReflectanceTags.VERY_HIGH, state)) {
            return 0.8f;
        }
        if (TAG_LIBRARY.is(ReflectanceTags.MAX, state)) {
            return 1.0f;
        }
        return BlockInfo.estimateReflectance(state);
    }

    private static float estimateReflectance(BlockState state) {
        String pathString;
        Float result = null;
        if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.FLOWERS, state)) {
            result = Float.valueOf(0.0f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.FENCES, state)) {
            result = Float.valueOf(0.0f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.FENCE_GATES, state)) {
            result = Float.valueOf(0.0f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.BEDS, state)) {
            result = Float.valueOf(0.0f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.TRAPDOORS, state)) {
            result = Float.valueOf(0.15f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.BANNERS, state)) {
            result = Float.valueOf(0.15f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.LEAVES, state)) {
            result = Float.valueOf(0.15f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.WOOL, state)) {
            result = Float.valueOf(0.15f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.WOOL_CARPETS, state)) {
            result = Float.valueOf(0.15f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.BUTTONS, state)) {
            result = Float.valueOf(0.0f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.DOORS, state)) {
            result = Float.valueOf(0.35f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.LOGS, state)) {
            result = Float.valueOf(0.15f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.TERRACOTTA, state)) {
            result = Float.valueOf(0.5f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.ICE, state)) {
            result = Float.valueOf(0.35f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.SIGNS, state)) {
            result = Float.valueOf(0.0f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.CROPS, state)) {
            result = Float.valueOf(0.0f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.CAULDRONS, state)) {
            result = Float.valueOf(0.5f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.SAPLINGS, state)) {
            result = Float.valueOf(0.0f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.STONE_ORE_REPLACEABLES, state)) {
            result = Float.valueOf(1.0f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.DAMPENS_VIBRATIONS, state)) {
            result = Float.valueOf(0.35f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.SWORD_EFFICIENT, state)) {
            result = Float.valueOf(0.0f);
        }
        if (result == null && (pathString = (String)state.getBlockHolder().unwrapKey().map(k -> k.location().getPath()).orElse(null)) != null) {
            if (pathString.contains("panes") || pathString.contains("wall")) {
                result = Float.valueOf(0.35f);
            } else if (pathString.contains("glass") || pathString.contains("dripstone")) {
                result = Float.valueOf(0.5f);
            } else if (pathString.contains("cobble") || pathString.contains("deepslate")) {
                result = Float.valueOf(0.65f);
            } else if (pathString.contains("stone") || pathString.contains("infested")) {
                result = Float.valueOf(1.0f);
            }
        }
        if (result == null) {
            result = Float.valueOf(0.35f);
        }
        return result.floatValue();
    }

    private static float getSoundOcclusionSetting(BlockState state) {
        if (TAG_LIBRARY.is(OcclusionTags.NONE, state)) {
            return 0.0f;
        }
        if (TAG_LIBRARY.is(OcclusionTags.VERY_LOW, state)) {
            return 0.15f;
        }
        if (TAG_LIBRARY.is(OcclusionTags.LOW, state)) {
            return 0.35f;
        }
        if (TAG_LIBRARY.is(OcclusionTags.MEDIUM, state)) {
            return 0.5f;
        }
        if (TAG_LIBRARY.is(OcclusionTags.HIGH, state)) {
            return 0.65f;
        }
        if (TAG_LIBRARY.is(OcclusionTags.VERY_HIGH, state)) {
            return 0.8f;
        }
        if (TAG_LIBRARY.is(OcclusionTags.MAX, state)) {
            return 1.0f;
        }
        return BlockInfo.estimateOcclusion(state);
    }

    private static float estimateOcclusion(BlockState state) {
        String pathString;
        Float result = null;
        if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.FLOWERS, state)) {
            result = Float.valueOf(0.0f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.FENCES, state)) {
            result = Float.valueOf(0.15f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.FENCE_GATES, state)) {
            result = Float.valueOf(0.15f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.BEDS, state)) {
            result = Float.valueOf(0.5f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.TRAPDOORS, state)) {
            result = Float.valueOf(0.15f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.BANNERS, state)) {
            result = Float.valueOf(0.15f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.LEAVES, state)) {
            result = Float.valueOf(0.35f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.WOOL, state)) {
            result = Float.valueOf(1.0f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.WOOL_CARPETS, state)) {
            result = Float.valueOf(0.65f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.BUTTONS, state)) {
            result = Float.valueOf(0.0f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.DOORS, state)) {
            result = Float.valueOf(0.35f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.LOGS, state)) {
            result = Float.valueOf(0.5f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.TERRACOTTA, state)) {
            result = Float.valueOf(0.5f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.ICE, state)) {
            result = Float.valueOf(0.35f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.SIGNS, state)) {
            result = Float.valueOf(0.0f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.CROPS, state)) {
            result = Float.valueOf(0.0f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.CAULDRONS, state)) {
            result = Float.valueOf(0.5f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.SAPLINGS, state)) {
            result = Float.valueOf(0.0f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.STONE_ORE_REPLACEABLES, state)) {
            result = Float.valueOf(0.65f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.OCCLUDES_VIBRATION_SIGNALS, state)) {
            result = Float.valueOf(0.65f);
        } else if (TAG_LIBRARY.is((TagKey<Block>)BlockTags.SWORD_EFFICIENT, state)) {
            result = Float.valueOf(0.0f);
        }
        if (result == null && (pathString = (String)state.getBlockHolder().unwrapKey().map(k -> k.location().getPath()).orElse(null)) != null) {
            if (pathString.contains("chest") || pathString.contains("glass")) {
                result = Float.valueOf(0.35f);
            } else if (pathString.contains("stone")) {
                result = Float.valueOf(0.65f);
            }
        }
        if (result == null) {
            result = Float.valueOf(state.canOcclude() ? 0.5f : 0.15f);
        }
        return result.floatValue();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("reflectivity: ").append(this.soundReflectivity).append("; occlusion: ").append(this.soundOcclusion).append("\n");
        if (this.stepSound != null) {
            builder.append("step sound: ").append(this.stepSound).append("\n");
        }
        if (!this.sounds.isEmpty()) {
            builder.append("sound chance: ").append(this.soundChance);
            builder.append("; sounds [\n");
            builder.append(this.sounds.stream().map(c -> "    " + c.toString()).collect(Collectors.joining("\n")));
            builder.append("\n]\n");
        }
        if (!this.blockEffects.isEmpty()) {
            builder.append("random effects [\n");
            builder.append(this.blockEffects.stream().map(c -> "    " + c.toString()).collect(Collectors.joining("\n")));
            builder.append("\n]\n");
        }
        return builder.toString();
    }

    private static class Reflectance {
        public static final float NONE = 0.0f;
        public static final float VERY_LOW = 0.15f;
        public static final float LOW = 0.35f;
        public static final float MEDIUM = 0.5f;
        public static final float HIGH = 0.65f;
        public static final float VERY_HIGH = 0.8f;
        public static final float MAX = 1.0f;
        public static final float VIBRATION = 0.35f;
        public static final float DEFAULT = 0.35f;

        private Reflectance() {
        }
    }

    private static class Occlusion {
        public static final float NONE = 0.0f;
        public static final float VERY_LOW = 0.15f;
        public static final float LOW = 0.35f;
        public static final float MEDIUM = 0.5f;
        public static final float HIGH = 0.65f;
        public static final float VERY_HIGH = 0.8f;
        public static final float MAX = 1.0f;
        public static final float VIBRATION = 0.65f;
        public static final float DEFAULT = 0.5f;
        public static final float DEFAULT_TRANSLUCENT = 0.15f;

        private Occlusion() {
        }
    }
}

