/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config.data;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.level.block.state.BlockState;
import org.orecruncher.dsurround.config.data.AcousticConfig;
import org.orecruncher.dsurround.config.data.BlockEffectConfigRule;
import org.orecruncher.dsurround.lib.CodecExtensions;
import org.orecruncher.dsurround.lib.IMatcher;
import org.orecruncher.dsurround.lib.scripting.Script;

public record BlockConfigRule(List<IMatcher<BlockState>> blocks, Boolean clearSounds, Optional<Script> soundChance, List<AcousticConfig> acoustics, List<BlockEffectConfigRule> effects) {
    public static final Codec<BlockConfigRule> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list(CodecExtensions.checkBlockStateSpecification(true)).fieldOf("blocks").forGetter(BlockConfigRule::blocks), (App)Codec.BOOL.optionalFieldOf("clearSounds", (Object)false).forGetter(BlockConfigRule::clearSounds), (App)Script.CODEC.optionalFieldOf("soundChance").forGetter(BlockConfigRule::soundChance), (App)Codec.list(AcousticConfig.CODEC).optionalFieldOf("acoustics", (Object)ImmutableList.of()).forGetter(BlockConfigRule::acoustics), (App)Codec.list(BlockEffectConfigRule.CODEC).optionalFieldOf("effects", (Object)ImmutableList.of()).forGetter(BlockConfigRule::effects)).apply((Applicative)instance, BlockConfigRule::new));

    public boolean match(BlockState state) {
        for (IMatcher<BlockState> rule : this.blocks) {
            if (!rule.match(state)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Blocks [\n");
        for (IMatcher<BlockState> matcher : this.blocks) {
            builder.append("  ").append(matcher.toString()).append("\n");
        }
        builder.append("]\n");
        builder.append("Clear Sounds: ").append(this.clearSounds).append("\n");
        builder.append("Sound Chance: ").append(this.soundChance.map(Script::asString).orElse("default")).append("\n");
        builder.append("Acoustics: [\n");
        for (AcousticConfig acoustic : this.acoustics) {
            builder.append("  ").append(acoustic.toString()).append("\n");
        }
        builder.append("]\n");
        builder.append("Block Effects: [\n");
        for (BlockEffectConfigRule effect : this.effects) {
            builder.append("  ").append(effect.toString()).append("\n");
        }
        builder.append("]\n");
        return builder.toString();
    }
}

