/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config.data;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.sounds.SoundSource;

public record SoundMetadataConfig(Optional<String> title, Optional<String> subtitle, Optional<SoundSource> category, List<CreditEntry> credits) {
    private static final Map<String, SoundSource> SOUND_SOURCE_BY_NAME = Arrays.stream(SoundSource.values()).collect(Collectors.toMap(SoundSource::getName, category -> category));
    public static final Codec<SoundSource> SOUND_SOURCE_CODEC = Codec.STRING.comapFlatMap(DataResult.partialGet(SOUND_SOURCE_BY_NAME::get, () -> "unknown sound category type"), SoundSource::getName);
    public static final Codec<SoundMetadataConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("ds_title").forGetter(SoundMetadataConfig::title), (App)Codec.STRING.optionalFieldOf("subtitle").forGetter(SoundMetadataConfig::subtitle), (App)SOUND_SOURCE_CODEC.optionalFieldOf("ds_category").forGetter(SoundMetadataConfig::category), (App)Codec.list(CreditEntry.CODEC).optionalFieldOf("ds_credits", (Object)ImmutableList.of()).forGetter(SoundMetadataConfig::credits)).apply((Applicative)instance, SoundMetadataConfig::new));

    public boolean isDefault() {
        return this.title.isEmpty() && this.subtitle.isEmpty() && this.credits.isEmpty() && this.category.isEmpty();
    }

    public record CreditEntry(String name, String author, Optional<String> website, String license) {
        public static final Codec<CreditEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(CreditEntry::name), (App)Codec.STRING.fieldOf("author").forGetter(CreditEntry::author), (App)Codec.STRING.optionalFieldOf("website").forGetter(CreditEntry::website), (App)Codec.STRING.fieldOf("license").forGetter(CreditEntry::license)).apply((Applicative)instance, CreditEntry::new));
    }
}

