/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config.libraries.impl;

import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.locale.Language;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import org.orecruncher.dsurround.config.SyntheticBiome;
import org.orecruncher.dsurround.config.biome.BiomeInfo;
import org.orecruncher.dsurround.config.biome.biometraits.BiomeTraits;
import org.orecruncher.dsurround.config.data.BiomeConfigRule;
import org.orecruncher.dsurround.config.libraries.IBiomeLibrary;
import org.orecruncher.dsurround.config.libraries.IReloadEvent;
import org.orecruncher.dsurround.lib.Guard;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.logging.ModLog;
import org.orecruncher.dsurround.lib.registry.RegistryUtils;
import org.orecruncher.dsurround.lib.resources.DiscoveredResource;
import org.orecruncher.dsurround.lib.resources.ResourceUtilities;
import org.orecruncher.dsurround.lib.scripting.Script;
import org.orecruncher.dsurround.mixinutils.IBiomeExtended;
import org.orecruncher.dsurround.runtime.BiomeConditionEvaluator;

public final class BiomeLibrary
implements IBiomeLibrary {
    private static final String FILE_NAME = "biomes.json";
    private static final Codec<List<BiomeConfigRule>> CODEC = Codec.list(BiomeConfigRule.CODEC);
    private final IModLog logger;
    private final BiomeConditionEvaluator biomeConditionEvaluator;
    private final Map<SyntheticBiome, BiomeInfo> internalBiomes = new EnumMap<SyntheticBiome, BiomeInfo>(SyntheticBiome.class);
    private final ObjectArray<BiomeConfigRule> biomeConfigs = new ObjectArray(128);
    private int version = 0;

    public BiomeLibrary(IModLog logger) {
        this.logger = ModLog.createChild(logger, "BiomeLibrary");
        this.biomeConditionEvaluator = new BiomeConditionEvaluator(this, logger);
    }

    @Override
    public void reload(ResourceUtilities resourceUtilities, IReloadEvent.Scope scope) {
        ++this.version;
        if (scope == IReloadEvent.Scope.TAGS) {
            this.logger.info("[BiomeLibrary] received tag update notification; version is now %d", this.version);
            return;
        }
        this.internalBiomes.clear();
        this.biomeConfigs.clear();
        this.biomeConditionEvaluator.reset();
        Collection<DiscoveredResource<List<BiomeConfigRule>>> findResults = resourceUtilities.findModResources(CODEC, FILE_NAME);
        findResults.forEach(result -> this.biomeConfigs.addAll((Collection)result.resourceContent()));
        this.biomeConfigs.sort(Comparator.comparingInt(BiomeConfigRule::priority));
        for (SyntheticBiome b : SyntheticBiome.values()) {
            this.initializeSyntheticBiome(b);
        }
        this.logger.info("[BiomeLibrary] %d biome configs loaded; version is now %d", this.biomeConfigs.size(), this.version);
    }

    private void initializeSyntheticBiome(SyntheticBiome biome) {
        String match = "@" + biome.getName();
        BiomeInfo info = new BiomeInfo(this.version, biome.getId(), biome.getName(), biome.getTraits());
        for (BiomeConfigRule c : this.biomeConfigs) {
            if (!c.biomeSelector().asString().equalsIgnoreCase(match)) continue;
            info.update(c);
        }
        this.internalBiomes.put(biome, info);
    }

    private static Registry<Biome> getActiveRegistry() {
        return RegistryUtils.getRegistry(Registries.BIOME).orElseThrow();
    }

    @Override
    public BiomeInfo getBiomeInfo(Biome biome) {
        String name;
        ResourceLocation id;
        BiomeInfo info = ((IBiomeExtended)biome).dsurround_getInfo();
        if (info != null && info.getVersion() == this.version) {
            return info;
        }
        if (info != null) {
            id = info.getBiomeId();
            name = info.getBiomeName();
        } else {
            id = BiomeLibrary.getBiomeId(biome);
            name = this.getBiomeName(id);
        }
        BiomeTraits traits = BiomeTraits.createFrom(id, biome);
        BiomeInfo result = new BiomeInfo(this.version, id, name, traits, biome);
        ((IBiomeExtended)biome).dsurround_setInfo(result);
        this.applyTraits(biome, result);
        Guard.execute(() -> this.applyRuleConfigs(biome, result));
        return result;
    }

    @Override
    public BiomeInfo getBiomeInfo(SyntheticBiome biome) {
        return this.internalBiomes.get((Object)biome);
    }

    @Override
    public Object eval(Biome biome, Script script) {
        BiomeInfo info = this.getBiomeInfo(biome);
        return this.biomeConditionEvaluator.eval(biome, info, script);
    }

    private void applyTraits(Biome biome, BiomeInfo info) {
        this.getNonSyntheticBiomeRules(rule -> !rule.traits().isEmpty()).forEach(rule -> {
            try {
                boolean applies = this.biomeConditionEvaluator.check(biome, info, rule.biomeSelector());
                if (applies) {
                    info.mergeTraits((BiomeConfigRule)rule);
                }
            }
            catch (Exception ex) {
                this.logger.warn("Unable to apply traits from [%s]", rule.toString());
            }
        });
    }

    private void applyRuleConfigs(Biome biome, BiomeInfo info) {
        this.getNonSyntheticBiomeRules(rule -> rule.traits().isEmpty()).forEach(rule -> {
            try {
                boolean applies = this.biomeConditionEvaluator.check(biome, info, rule.biomeSelector());
                if (applies) {
                    try {
                        info.update((BiomeConfigRule)rule);
                    }
                    catch (Throwable t) {
                        this.logger.warn("Unable to process biome sound configuration [%s]", rule.toString());
                    }
                }
            }
            catch (Throwable t) {
                this.logger.error(t, "Unexpected error processing biome %s", info.getBiomeId());
            }
        });
        info.trim();
    }

    private Stream<BiomeConfigRule> getNonSyntheticBiomeRules(Predicate<BiomeConfigRule> filter) {
        return this.biomeConfigs.stream().filter(c -> !c.biomeSelector().asString().startsWith("@")).filter(filter);
    }

    private static ResourceLocation getBiomeId(Biome biome) {
        return RegistryUtils.getRegistryEntry(Registries.BIOME, biome).map(holder -> ((ResourceKey)holder.unwrapKey().orElseThrow()).location()).orElseThrow();
    }

    @Override
    public String getBiomeName(ResourceLocation id) {
        String fmt = String.format("biome.%s.%s", id.getNamespace(), id.getPath());
        return Language.getInstance().getOrDefault(fmt);
    }

    @Override
    public Stream<String> dump() {
        Stream<String> realBiomes = BiomeLibrary.getActiveRegistry().stream().map(this::getBiomeInfo).map(BiomeInfo::toString).sorted();
        Stream<String> fakeBiomes = this.internalBiomes.values().stream().map(BiomeInfo::toString).sorted();
        return Stream.of(realBiomes, fakeBiomes).flatMap(Function.identity());
    }
}

