/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config.libraries.impl;

import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import org.orecruncher.dsurround.config.block.BlockInfo;
import org.orecruncher.dsurround.config.data.BlockConfigRule;
import org.orecruncher.dsurround.config.libraries.IBlockLibrary;
import org.orecruncher.dsurround.config.libraries.IReloadEvent;
import org.orecruncher.dsurround.config.libraries.ITagLibrary;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.logging.ModLog;
import org.orecruncher.dsurround.lib.platform.IMinecraftDirectories;
import org.orecruncher.dsurround.lib.registry.RegistryUtils;
import org.orecruncher.dsurround.lib.resources.DiscoveredResource;
import org.orecruncher.dsurround.lib.resources.ResourceUtilities;
import org.orecruncher.dsurround.mixinutils.IBlockStateExtended;

public class BlockLibrary
implements IBlockLibrary {
    private static final String FILE_NAME = "blocks.json";
    private static final Codec<List<BlockConfigRule>> CODEC = Codec.list(BlockConfigRule.CODEC);
    private static final int INDEFINITE = -1;
    private static final BlockInfo DEFAULT = new BlockInfo(-1){

        @Override
        public boolean isDefault() {
            return true;
        }
    };
    private final IModLog logger;
    private final IMinecraftDirectories directories;
    private final ITagLibrary tagLibrary;
    private final Collection<BlockConfigRule> blockConfigs = new ObjectArray<BlockConfigRule>();
    private int version = 0;

    public BlockLibrary(IModLog logger, IMinecraftDirectories directories, ITagLibrary tagLibrary) {
        this.logger = ModLog.createChild(logger, "BlockLibrary");
        this.directories = directories;
        this.tagLibrary = tagLibrary;
    }

    @Override
    public void reload(ResourceUtilities resourceUtilities, IReloadEvent.Scope scope) {
        ++this.version;
        if (scope == IReloadEvent.Scope.TAGS) {
            this.logger.info("[BlockLibrary] received tag update notification; version is now %d", this.version);
            return;
        }
        this.blockConfigs.clear();
        Collection<DiscoveredResource<List<BlockConfigRule>>> findResults = resourceUtilities.findModResources(CODEC, FILE_NAME);
        findResults.forEach(result -> this.blockConfigs.addAll((Collection)result.resourceContent()));
        this.logger.info("[BlockLibrary] %d block configs loaded; version is now %d", this.blockConfigs.size(), this.version);
    }

    @Override
    public BlockInfo getBlockInfoWeak(BlockState state) {
        BlockInfo info = ((IBlockStateExtended)state).dsurround_getBlockInfo();
        return info != null ? info : DEFAULT;
    }

    @Override
    public BlockInfo getBlockInfo(BlockState state) {
        BlockInfo info = ((IBlockStateExtended)state).dsurround_getBlockInfo();
        if (info != null && (info.getVersion() == this.version || info == DEFAULT)) {
            return info;
        }
        info = new BlockInfo(this.version, state);
        this.blockConfigs.stream().filter(c -> c.match(state)).forEach(info::update);
        if (info.isDefault()) {
            info = DEFAULT;
        } else {
            info.trim();
        }
        ((IBlockStateExtended)state).dsurround_setBlockInfo(info);
        return info;
    }

    @Override
    public Stream<String> dumpBlockStates() {
        return RegistryUtils.getRegistry(Registries.BLOCK).orElseThrow().stream().flatMap(block -> block.getStateDefinition().getPossibleStates().stream()).map(StateHolder::toString).sorted();
    }

    @Override
    public Stream<String> dumpBlockConfigRules() {
        return this.blockConfigs.stream().map(BlockLibrary::formatBlockConfigRuleOutput).sorted();
    }

    @Override
    public Stream<String> dumpBlocks(boolean noStates) {
        Registry blockRegistry = RegistryUtils.getRegistry(Registries.BLOCK).orElseThrow();
        Set entrySet = blockRegistry.entrySet();
        return entrySet.stream().map(kvp -> this.formatBlockOutput(((ResourceKey)kvp.getKey()).location(), (Block)kvp.getValue(), noStates)).sorted();
    }

    @Override
    public Stream<String> dump() {
        return this.tagLibrary.getEntriesByTag(Registries.BLOCK).map(pair -> BlockLibrary.formatBlockTagOutput((TagKey<Block>)((TagKey)pair.key()), (Set)pair.value())).sorted();
    }

    private static String formatBlockConfigRuleOutput(BlockConfigRule rule) {
        return rule.toString();
    }

    private static String formatBlockTagOutput(TagKey<Block> blockTag, Set<Block> blocks) {
        Registry blockRegistry = RegistryUtils.getRegistry(Registries.BLOCK).orElseThrow();
        StringBuilder builder = new StringBuilder();
        builder.append("Tag: ").append(blockTag.location());
        blocks.stream().map(b -> Objects.requireNonNull(blockRegistry.getKey(b)).toString()).sorted().forEach(tag -> builder.append("\n  ").append((String)tag));
        builder.append("\n");
        return builder.toString();
    }

    private String formatBlockOutput(ResourceLocation id, Block block, boolean noStates) {
        Holder.Reference<Block> entry = RegistryUtils.getRegistryEntry(Registries.BLOCK, block).orElseThrow();
        Stream t = this.tagLibrary.streamTags(entry);
        String tags = this.tagLibrary.asString(t);
        StringBuilder builder = new StringBuilder();
        builder.append(id.toString());
        builder.append("\nTags: ").append(tags);
        BlockInfo info = this.getBlockInfo(block.defaultBlockState());
        builder.append("\nreflectance: ").append(info.getSoundReflectivity());
        builder.append("; occlusion: ").append(info.getSoundOcclusion());
        if (!noStates) {
            builder.append("\nstates [\n");
            for (BlockState blockState : block.getStateDefinition().getPossibleStates()) {
                builder.append("  ").append(blockState.toString()).append("\n");
            }
            builder.append("]");
        }
        builder.append("\n");
        return builder.toString();
    }
}

